Vue.component('client', {
  mixins: [crud, crud_front],
  data: function () {
    return {
        current_row: this.current_row,
        form_data: this.form_data
    }
  },
  template: `
<div>

  <div v-if="data">
    <standard-table
      perpage="10"
      :rows="data"
      :current_row="current_row"
      :fields="[
          {name:'id', 'title': 'Id', type:'number', sort: true},
          {name:'name', 'title': 'Name', type:'string', sort: true},
          {name:'phone', 'title': 'Phone', type:'string', sort: true},
          {name:'address', 'title': 'Address', type:'string', sort: true}
      ]"
      :actions="[
          /*{name:'read', title: 'R', action: 'read', class: ''},
          {name:'update', title: 'U', action: 'update', class: ''},
          */
          {name:'select', title: 'Select', action: 'select', class: ''},
          {name:'delete', title: 'Delete', action: 'delete', class: ''}
      ]"
      perpage="10"
      @select="selectRow($event)"
      @read="read_front($event)"
      @update="update_front({'id':$event.id, 'name': $event.name , 'phone': 'Updated phone', 'address': 'Updated address'})"
      @delete="delete_front($event); form_data = null"
    />

    <div v-if="form_data">
        <h2>Form</h2>
        <standard-form
            :data="form_data"
            :fields="[
                {name:'id', 'title': 'Id', type:'number'},
                {name:'name', 'title': 'Name', type:'string'},
                {name:'phone', 'title': 'Phone', type:'string'},
                {name:'address', 'title': 'Address', type:'string'}
            ]"
            :actions="[
                {name:'submit', title: 'Save', action: 'Save', class: '', dafault: true},
                {name:'cancel', title: 'Cancel', action: 'Cancel', class: ''}
            ]"
            @action="doAction($event)"
        />
    </div>

    <button @click="form_data = {'id':-1, 'name':'', phone:'', 'address':''}" class="btn btn-primary">Create</button>
  </div>

</div>`,
  mounted: function() {
    store.commit('title', 'Client')
    this.instance = 'client'
    this.read_front()
  },
  methods: {
    selectRow: function (row) {
        this.current_row = row
        this.form_data = Object.assign({}, row)
    },
    doAction: function($event) {
        if ($event.action.name == 'cancel') {
            this.form_data = null
        }
        if ($event.action.name == 'submit') {
            if ($event.row.id > 0) {
                this.update_front($event.row)
                this.form_data = null
            }
            else {
                this.create_front($event.row)
                this.form_data = null
            }
        }
    }
  }
})

app.componentsLoaded('client')