Vue.component('v-style', {
  render: function (createElement) {
    return createElement('style', this.$slots.default)
  }
});

Vue.component('standard-table', {
  mixins: [table],
  props:['fields', 'actions'],
  computed: {
      sortFields: function () {
          let fields = []
          for (field of this.fields) {
              if ( (typeof field.sort !== 'undefined') && (typeof field.name !== 'undefined') && (typeof field.title !== 'undefined') && (typeof field.type !== 'undefined') ){
                  fields.push({field:field.name, caption:field.title, type:field.type})
              }
          }
          return fields
      }
  },
  template: `
<div>
  <table-menu @filter="search=$event"
    @order="order($event.field, $event.type)"
    :sorting="sortFields"
    :orderField="orderField"
    :orderReverse="orderReverse"
  />

  <u-table>
  <u-tr>
    <u-th v-for="field in fields">
        <template v-if="field.sort">
            <header-order :field="field.name" :orderField="orderField" :orderReverse="orderReverse" v-on:click="order($event, field.type)">{{field.title}}</header-order>
        </template>
        <template v-else>
            {{field.title}}
        </template>
    </u-th>
    <u-th v-if="actions">Action</u-th>
  </u-tr>
  <u-tr v-for="row in paginatedRows">
    <u-td v-for="field in fields" :label="field.title">{{row[field.name]}}</u-td>
    <u-td v-if="actions">
        <a v-for="action in actions" @click="doAction(action, row)" :title="action.title" class="mr-1"><span :class="action.class">{{action.title}}</span></a>
    </u-td>
  </u-tr>
  </u-table>
  <paginator v-bind:pages="pages" gap="5" v-bind:currentPage="currentPage" v-on:setPage="setPage($event)" v-on:setPrevPage="setPrevPage()" v-on:setNextPage="setNextPage()" class="text-center"></paginator>
</div>
`,
methods: {
  doAction: function (action, row) {
    this.$emit(action.action, row)
  }
}
})

Vue.component('paginator', {
  props: {
    pages: Number,
    currentPage: Number,
    gap: Number,
    loading: Boolean
  },
  template: `
<nav v-show="pages > 1">
  <v-style>
    @media (max-width: 480px) {
      .xsm-hide {
        display: none !important;
      }
    }
  </v-style>
  <ul class="pagination justify-content-center">
    <li class="page-item" v-bind:class="{disabled: currentPage == 1}"><a @click="$emit('setPage', 1)" class="page-link">«</a></li>
    <li class="page-item" v-bind:class="{disabled: currentPage == 1}"><a @click="$emit('setPrevPage')" class="page-link">‹</a></li>
    <li v-for="page in rangepage" :class="'page-item' + (currentPage==page?' active':'')"><a @click="$emit('setPage', page)" class="page-link">{{page}}</a></li>
    <li class="page-item" v-bind:class="{disabled: currentPage == pages}"><a @click="$emit('setNextPage')" class="page-link">›</a></li>
    <li class="page-item" v-bind:class="{disabled: currentPage == pages}"><a @click="$emit('setPage', pages)" class="page-link">»</a></li>
  </ul>
</nav>`,
  computed: {
    ver () {
      return this.version==null?1:this.version
    },
    rangepage () {
      let ret = []
      let gap = 5
      let size = this.pages
      let page = this.currentPage

      if (typeof this.pages === 'undefined')
        return ret

      if (typeof this.gap !== 'undefined')
        gap = parseInt(this.gap) - 1 // Проверить как работает везде

      let start = page - Math.floor(gap / 2)
      if (start < 1)
        start = 1

      var end = start + gap
      if (end > size) {
        end = size
        start = end - gap
        if (start < 1)
          start = 1
      }

      for (var i = start; i <= end; i++) {
        ret.push(i)
      }

      return ret
    }
  },
  created: function () {
    //this.onscroll = _.throttle(this._onscroll, 100)
  },
  mounted: function () {
    window.addEventListener('scroll', this.onscroll)
  },
  destroyed: function () {
    window.removeEventListener('scroll', this.onscroll)
  },
  methods: {
    //_onscroll: function () {
    onscroll: function () {
      let width = window.innerWidth
      let height = window.innerHeight
      let scrollTop = document.documentElement.scrollTop
      let document_height = document.documentElement.scrollHeight

      if (width < 1024) {
        if(height + scrollTop >= document_height ) {
          this.$emit('addNextPage')
        }
      }
    }
  }
})

Vue.component('header-order', {
  props: ['field', 'orderField', 'orderReverse'],
  template: `
<a @click="$emit('click', field)"><slot></slot>
<span v-if="orderField == field">
    <span v-if="orderReverse">&#11014;</span>
    <span v-else>&#11015;</span>
</span>
</a>`
})

Vue.component('table-menu', {
  props: ['sorting', 'orderField', 'orderReverse', 'showReload'],
  data: function () {
    return {
      show: this.show,
      filter: this.search,
    }
  },
  computed: {
    sortCaption: function () {
      return this.findOf(this.sorting, this.orderField, 'field', 'caption')
    }
  },
  template: `
<div>
  <a @click="toggleShow()" title="Show/Hide">&#x2630;</a>&nbsp;<a v-if="showReload" @click="$emit('reload')" title="Reload (Alt+F5)"><span class="feather icon-refresh-cw"></span></a>

    <div class="row mr-3 mt-1 mb-1" v-if="show">
      <div class="col-auto">
        <input type="text" class="form-control input-sm auto-width" maxlength="25" v-model="filter" @keyup="changeFilter()" placeholder="search">
      </div>
      <div class="col">
        <md-menu v-if="sorting">
          <md-button md-menu-trigger class="text-left">
            <a>
              <small v-if="orderField" title="Order by field">
                <span v-if="orderReverse">&#11014;</span>
                <span v-else>&#11015;</span>
                {{sortCaption}}
              </small>
              <span v-else title="Order by field">&#11014;&#11015;</span> 
            </a>
          </md-button>

          <md-menu-content>
            <md-menu-item v-for="item in sorting" @click="changeOrder(item)">{{item.caption}}</md-menu-item>
          </md-menu-content>
        </md-menu>
      </div>
    </div>

</div>`,
mounted: function() {
  this.show = false
  this.filter = ''
},
methods: {
  toggleShow: function () {
    this.show = !this.show
    if (!this.show) {
      this.filter = ''
      this.changeFilter()
    }
  },
  changeFilter: function () {
    this.$emit('filter', this.filter)
  },
  changeOrder: function (item) {
    this.$emit('order', item)
  },
  findOf: function (obj, value, key, caption) {
    if ((obj == null) || (key == null) || (obj == value))
      return

    for (let i = 0; i < obj.length; i++) {
      if (obj[i][key] == value)
        return obj[i][caption]
    }
  }
}
})

Vue.component('u-table', {
  template: `
  <div classs="table-container">
    <table class="table table-bordered table-striped desktop-mobile">
        <slot></slot>
    </table>
  </div>
  `
})

Vue.component('u-tr', {
  template: `<tr><slot></slot></tr>`
})

Vue.component('u-th', {
  template: `<th><slot></slot></th>`
})

Vue.component('u-td', {
  props: ['label'],
  template: `<td><slot></slot><span class="td-label" v-if="label" v-html="label"></span></td>`
})


Vue.component('app-menu', {
  data: function () {
	return {
		sections: this.sections
	}
  },
  template: `
<nav class="col-md-2 d-none d-md-block bg-light sidebar">
  <div v-if="sections" class="sidebar-sticky">
    <span v-for="section in sections">
      <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
        <span>{{section.section}}</span>
        <a class="d-flex align-items-center text-muted" href="#"></a>
      </h6>
      <ul class="nav flex-column">
        <a v-for="item in section.items" class="nav-link" :href="item.path">{{item.item}}</a>
      </ul>
    </span>
  </div>
</nav>
`,
mounted: function () {
  this.sections = [
    {
    "section": "Main menu",
        "items": [
            {
              "item": "Default",
              "path": "#/"
            },
            {
                "item": "Сlient",
                "path": "#/client"
            },
            {
                "item": "Seller",
                "path": "#/seller"
            }
        ]
    },

    {
    "section": "Secondary menu",
        "items": [
            {
                "item": "Product",
                "path": "#/product"
            }
        ]
    }
  ]
}
})



Vue.component('default', {
  template: `
<div>
  <h2>Стандартная таблица. Минимизируем код.</h2>

  <p>Для того, чтобы заполнить Localstorage исходными данными, нажмите кнопку ниже.</p>

  <div>
    <button @click="initData()" class="btn btn-primary">Fill Local Storage</button>
  </div>

  <p></p>
  <p>После перехожите в пункт меню <a href="#/client">Сlient</a> для просмотра работы примера.</p>

</div>`,
  mounted: function() {
    store.commit('title', 'Default')
  },
  methods: {
    initData: function () {
      let client = [
        {'id':1, 'name': 'Atomuli Yadalato', 'phone': '+5010674373431', 'address': 'Syracuse, 2528  Oak Street'},
        {'id':2, 'name': 'Sovseiduri Oherachu', 'phone': '+2290504407434', 'address': '2671  Oakmound Drive'},
        {'id':3, 'name': 'Matzal Cats', 'phone': '+387664683394', 'address': '2172  Ella Street'},
        {'id':4, 'name': 'Yatasuka Nakomode', 'phone': '+380504457494', 'address': '163  Moore Avenue'},
        {'id':5, 'name': 'Fire-Bow de Bleu', 'phone': '+359504467844', 'address': '3813  Kenwood Place'},
        {'id':6, 'name': 'Hans Trachenbürger', 'phone': '+210504455773', 'address': '1008  Broadway Avenue'},
        {'id':7, 'name': 'Bzdashek Zapadlovsky', 'phone': '+2265046234714', 'address': '1083  Woodland Terrace'},
        {'id':8, 'name': 'Thanos Slyunidopolu', 'phone': '+6840504670154', 'address': '2529  Briarhill Lane'},
        {'id':9, 'name': 'Kheranuka Poroyalu', 'phone': '+855504456780', 'address': '4751  Corbin Branch Road'},
        {'id':10, 'name': 'Ushat Pomoev', 'phone': '+235504453457', 'address': '1960  Gore Street'},
        {'id':11, 'name': 'Harem Playboys', 'phone': '+357504462859', 'address': '81  Monroe Avenue'},
        {'id':12, 'name': 'Marazmus Nolemotsiy', 'phone': '+620506379083', 'address': '1245  Duff Avenue'},
        {'id':13, 'name': 'Orido Pota', 'phone': '+200567890432', 'address': '2091  Braxton Street'},
        {'id':14, 'name': 'Olivier Ju yes Swallow', 'phone': '+500453268901', 'address': '4940  Chardonnay Drive'},
        {'id':15, 'name': 'Rucishchito Shirehari', 'phone': '+3585345628972', 'address': '4069  Austin Secret Lane'},
        {'id':16, 'name': 'Stoyana Rakova', 'phone': '+490345246783', 'address': '349  Bombardier Way'},
        {'id':17, 'name': 'Spiro Napolnasrakis', 'phone': '+955412324306', 'address': '130  Smithfield Avenue'},
        {'id':18, 'name': 'Helga Schlucher', 'phone': '+910564738018', 'address': '1199  State Street'}
      ]
      localStorage.setItem('client', JSON.stringify(client))

      let seller = [
        {'id':1, 'name': 'Paula Anderson', 'phone': '+5010674373431', 'email': 'paula@gggmail.com'},
        {'id':2, 'name': 'Sibostyan Polin', 'phone': '+2290504407434', 'email': 'polin@gggmail.com'},
        {'id':3, 'name': 'Jhon Malberg', 'phone': '+387664683394', 'email': 'malberg@gggmail.com'},
        {'id':4, 'name': 'Yakuha Manu', 'phone': '+380504457494', 'email': 'manu@gggmail.com'},
        {'id':5, 'name': 'Bella Krakovich', 'phone': '+359504467844', 'email': 'krakovich@gggmail.com'}
      ]

      localStorage.setItem('seller', JSON.stringify(seller))

      let product = [
        {'id':1, 'name': 'Support shaft assembly', 'code': '106743734317', 'price': 356.30, 'warehouse': '1'},
        {'id':2, 'name': 'Arow plate', 'code': '789798734317', 'price': 1356.00, 'warehouse': '1'},
        {'id':3, 'name': 'Square-ended shaft', 'code': '65448917', 'price': 755.50, 'warehouse': '1'},
        {'id':4, 'name': 'Gland flange', 'code': '45646734317', 'price': 112.70, 'warehouse': '1'},
        {'id':5, 'name': 'Bearing bushing', 'code': '46546434317', 'price': 56.80, 'warehouse': '1'},
        {'id':6, 'name': 'V-ring packing', 'code': '32131734317', 'price': 552.17, 'warehouse': '1'},
      ]

      localStorage.setItem('product', JSON.stringify(product))

    }
  }
})

Vue.component('client', {
  mixins: [crud, crud_front],
  template: `
<div>

  <div v-if="data">
    <standard-table
      perpage="10"
      :rows="data"
      :fields="[
          {name:'id', 'title': 'Id', type:'number', sort: true},
          {name:'name', 'title': 'Name', type:'string', sort: true},
          {name:'phone', 'title': 'Phone', type:'string', sort: true},
          {name:'address', 'title': 'Address', type:'string', sort: true}
      ]"
      :actions="[
          {name:'read', title: 'R', action: 'read', class: ''},
          {name:'update', title: 'U', action: 'update', class: ''},
          {name:'delete', title: 'D', action: 'delete', class: ''}
      ]"
      perpage="10"
      @read="read_front($event)"
      @update="update_front({'id':$event.id, 'name': $event.name , 'phone': 'Updated phone', 'address': 'Updated address'})"
      @delete="delete_front($event)"
    />

    <button @click="create_front({'id':19, 'name': 'Poll Anderson', 'phone': '+380670000000', 'address': '3 Stalingrada, Kyiv, Ukraine'})">C</button>
  </div>

</div>`,
  mounted: function() {
    store.commit('title', 'Client')
    this.instance = 'client'
    this.read_front()
  }
})



Vue.component('seller', {
  mixins: [crud, crud_front],
  template: `
<div>

  <standard-table v-if="data"
    perpage="10"
    :rows="data"
    :fields="[
        {name:'name', 'title': 'Name', type:'string', sort: true},
        {name:'phone', 'title': 'Phone', type:'string', sort: true},
        {name:'email', 'title': 'E-mail', type:'string', sort: true}
    ]"
    perpage="10"
  />

</div>`,
  mounted: function() {
    store.commit('title', 'Seller')
    this.instance = 'seller'
    this.read_front()
  }
})

Vue.component('product', {
  mixins: [crud, crud_front],
  template: `
<div>

  <standard-table v-if="data"
    perpage="10"
    :rows="data"
    :fields="[
        {name:'code', 'title': 'Code', type:'string', sort: true},
        {name:'name', 'title': 'Name', type:'string', sort: true},
        {name:'price', 'title': 'Price', type:'number', sort: true},
        {name:'warehouse', 'title': 'Warehouse', type:'string', sort: true}
    ]"
    perpage="10"
  />

</div>`,
  mounted: function() {
    store.commit('title', 'Product')
    this.instance = 'product'
    this.read_front()
  }
})
