"use strict";

/* Common storage */
const store = new Vuex.Store({
  state: {
    title: ''
  },
  mutations: {
    title (state, value) {
      state.title = value
    }
  }
})

/* ROUTES */
const routes = [
  { path: '/', component: { template: '<default />' }  },
  { path: '/client', component: { template: '<client />' } },
  { path: '/seller', component: { template: '<seller />' } },
  { path: '/product', component: { template: '<product />' } }
]

const router = new VueRouter({routes})
const urlHash = '#'

var app = new Vue({
  el: '#App',
  router: router,
  store: store
})
