var crud = {
  data : function () {
    return {
      data: this.data,
      instance: this.instance
    }
  },
  methods: {
    create_back: function (row, callbackOK, callbackError) {
      try {
        let rows = JSON.parse(localStorage.getItem(this.instance))
        rows.push(row)
        this.saveData(rows)
        if (callbackOK) {
          callbackOK(row)
        }
      }
      catch (e) {
        if (callbackError) {
          callbackError({'errors':['cath_error']})
        }
      }
    },
    read_back: function (row, callbackOK, callbackError) {
      try {
        if (row) {
          // read one recrd
          let rows = JSON.parse(localStorage.getItem(this.instance))
          for (item of rows) {
            if (item['id'] == row['id']) {
              if (callbackOK) {
                callbackOK(item)
              }
              return
            }
          }
          // Nothing found
          if (callbackError) {
            callbackError({'errors':['nothing_found']})
          }
        }
        else {
          // read all records
          callbackOK(JSON.parse(localStorage.getItem(this.instance)))
        }
      }
      catch (e) {
        if (callbackError) {
          callbackError({'errors':['cath_error']})
        }
      }
    },
    update_back: function (row, callbackOK, callbackError) {
      try {
        let rows = JSON.parse(localStorage.getItem(this.instance))
        for (let index in rows) {
          if (rows[index]['id'] == row['id']) {
            rows[index] = row
            this.saveData(rows)
            if (callbackOK) {
              callbackOK(rows[index])
            }
          }
        }
      }
      catch (e) {
        if (callbackError) {
          callbackError({'errors':['cath_error']})
        }
      }
    },
    delete_back: function (row, callbackOK, callbackError) {
      try {
        let rows = JSON.parse(localStorage.getItem(this.instance))
        for (let index in rows) {
          if (rows[index]['id'] == row['id']) {
            rows.splice(index, 1)
            this.saveData(rows)
            if (callbackOK) {
              callbackOK({'result': 'OK'})
            }
          }
        }
      }
      catch (e) {
        if (callbackError) {
          callbackError({'errors':['cath_error']})
        }
      }
    },

    ///////////////////////////////////////////////////////
    //this method used only for local storage
    //this method not needed when you'll use real backend
    ///////////////////////////////////////////////////////
    saveData: function (rows) {
      localStorage.setItem(this.instance, JSON.stringify(rows))
    },
    ///////////////////////////////////////////////////////




  }
}

var crud_front = {
    methods: {
        create_front: function (row) {
            this.create_back(row, ()=>{
              this.data.push(row)
            })
          },
          read_front: function (row) {
            this.read_back(row, (response)=>{
              if (row) {
                // update row
                for (key in response) {
                  row[key] = response[key]
                }
              }
              else {
                // update data
                this.data = response
              }
            })
          },
          update_front: function (row) {
            this.update_back(row, ()=>{
              for (item of this.data) {
                if (item['id'] == row['id']) {
                  this.read_front(item)
                }
              }
            })
          },
          delete_front: function (row) {
            this.delete_back(row, ()=>{
              this.data.splice(this.data.indexOf(row), 1)
            });
          },
          show_error: function(response) {
            console.log(response)
          }
    }
}