Vue.component('app-menu', {
  data: function () {
	return {
		sections: this.sections
	}
  },
  template: `
<nav class="col-md-2 d-none d-md-block bg-light sidebar">
  <div v-if="sections" class="sidebar-sticky">
    <span v-for="section in sections">
      <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
        <span>{{section.section}}</span>
        <a class="d-flex align-items-center text-muted" href="#"></a>
      </h6>
      <ul class="nav flex-column">
        <a v-for="item in section.items" class="nav-link" :href="item.path">{{item.item}}</a>
      </ul>
    </span>
  </div>
</nav>
`,
mounted: function () {
  this.sections = [
    {
    "section": "Main menu",
        "items": [
            {
              "item": "Default",
              "path": "#/"
            },
            {
                "item": "Сlient",
                "path": "#/client"
            },
            {
                "item": "Seller",
                "path": "#/seller"
            }
        ]
    },

    {
    "section": "Secondary menu",
        "items": [
            {
                "item": "Product",
                "path": "#/product"
            }
        ]
    }
  ]
}
})

Vue.component('default', {
  template: `
<div>

  <h2>Mixins</h2>

  <p>Для того, чтобы заполнить Localstorage исходными данными, нажмите кнопку ниже.</p>

  <div>
    <button @click="initData()" class="btn btn-primary">Fill Local Storage</button>
  </div>

  <p></p>
  <p>После перехожите в пункт меню <a href="#/client">Сlient</a> для просмотра работы примера.</p>

</div>`,
  mounted: function() {
    store.commit('title', 'Default')
  },
  methods: {
    initData: function () {
      let client = [
        {'id':1, 'name': 'Atomuli Yadalato', 'phone': '+5010674373431', 'address': 'Syracuse, 2528  Oak Street'},
        {'id':2, 'name': 'Sovseiduri Oherachu', 'phone': '+2290504407434', 'address': '2671  Oakmound Drive'},
        {'id':3, 'name': 'Matzal Cats', 'phone': '+387664683394', 'address': '2172  Ella Street'},
        {'id':4, 'name': 'Yatasuka Nakomode', 'phone': '+380504457494', 'address': '163  Moore Avenue'},
        {'id':5, 'name': 'Fire-Bow de Bleu', 'phone': '+359504467844', 'address': '3813  Kenwood Place'},
        {'id':6, 'name': 'Hans Trachenbürger', 'phone': '+210504455773', 'address': '1008  Broadway Avenue'},
        {'id':7, 'name': 'Bzdashek Zapadlovsky', 'phone': '+2265046234714', 'address': '1083  Woodland Terrace'},
        {'id':8, 'name': 'Thanos Slyunidopolu', 'phone': '+6840504670154', 'address': '2529  Briarhill Lane'},
        {'id':9, 'name': 'Kheranuka Poroyalu', 'phone': '+855504456780', 'address': '4751  Corbin Branch Road'},
        {'id':10, 'name': 'Ushat Pomoev', 'phone': '+235504453457', 'address': '1960  Gore Street'},
        {'id':11, 'name': 'Harem Playboys', 'phone': '+357504462859', 'address': '81  Monroe Avenue'},
        {'id':12, 'name': 'Marazmus Nolemotsiy', 'phone': '+620506379083', 'address': '1245  Duff Avenue'},
        {'id':13, 'name': 'Orido Pota', 'phone': '+200567890432', 'address': '2091  Braxton Street'},
        {'id':14, 'name': 'Olivier Ju yes Swallow', 'phone': '+500453268901', 'address': '4940  Chardonnay Drive'},
        {'id':15, 'name': 'Rucishchito Shirehari', 'phone': '+3585345628972', 'address': '4069  Austin Secret Lane'},
        {'id':16, 'name': 'Stoyana Rakova', 'phone': '+490345246783', 'address': '349  Bombardier Way'},
        {'id':17, 'name': 'Spiro Napolnasrakis', 'phone': '+955412324306', 'address': '130  Smithfield Avenue'},
        {'id':18, 'name': 'Helga Schlucher', 'phone': '+910564738018', 'address': '1199  State Street'}
      ]
      localStorage.setItem('client', JSON.stringify(client))

      let seller = [
        {'id':1, 'name': 'Paula Anderson', 'phone': '+5010674373431', 'email': 'paula@gggmail.com'},
        {'id':2, 'name': 'Sibostyan Polin', 'phone': '+2290504407434', 'email': 'polin@gggmail.com'},
        {'id':3, 'name': 'Jhon Malberg', 'phone': '+387664683394', 'email': 'malberg@gggmail.com'},
        {'id':4, 'name': 'Yakuha Manu', 'phone': '+380504457494', 'email': 'manu@gggmail.com'},
        {'id':5, 'name': 'Bella Krakovich', 'phone': '+359504467844', 'email': 'krakovich@gggmail.com'}
      ]

      localStorage.setItem('seller', JSON.stringify(seller))

      let product = [
        {'id':1, 'name': 'Support shaft assembly', 'code': '106743734317', 'price': 356.30, 'warehouse': '1'},
        {'id':2, 'name': 'Arow plate', 'code': '789798734317', 'price': 1356.00, 'warehouse': '1'},
        {'id':3, 'name': 'Square-ended shaft', 'code': '65448917', 'price': 755.50, 'warehouse': '1'},
        {'id':4, 'name': 'Gland flange', 'code': '45646734317', 'price': 112.70, 'warehouse': '1'},
        {'id':5, 'name': 'Bearing bushing', 'code': '46546434317', 'price': 56.80, 'warehouse': '1'},
        {'id':6, 'name': 'V-ring packing', 'code': '32131734317', 'price': 552.17, 'warehouse': '1'},
      ]

      localStorage.setItem('product', JSON.stringify(product))

    }
  }
})

Vue.component('client', {
  mixins: [crud, crud_front],
  template: `
<div>

  <table class="table">
    <tr>
      <th>ID</th>
      <th>Name</th>
      <th>Phone</th>
      <th>Address</th>
      <th>Action</th>
    </>
    <tr v-for="row in data">
      <td>{{row.id}}</td>
      <td>{{row.name}}</td>
      <td>{{row.phone}}</td>
      <td>{{row.address}}</td>
      <td>
        <button @click="read_front(row)">R</button>
        <button @click="update_front({'id':row.id, 'name': row.name , 'phone': 'Updated phone', 'address': 'Updated address'})">U</button>
        <button @click="delete_front(row)">D</button>
      </td>
    </tr>
  </table>
  
  <button @click="create_front({'id':19, 'name': 'Poll Anderson', 'phone': '+380670000000', 'address': '3 Stalingrada, Kyiv, Ukraine'})">C</button>

</div>`,
  mounted: function() {
    store.commit('title', 'Client')
    this.instance = 'client'
    this.read_front()
  }
})


Vue.component('seller', {
  mixins: [crud, crud_front],
  template: `
<div>

  <table class="table">
  <tr>
    <th>Name</th>
    <th>Phone</th>
    <th>E-mail</th>
  </>
  <tr v-for="row in data">
    <td>{{row.name}}</td>
    <td>{{row.phone}}</td>
    <td>{{row.email}}</td>
  </tr>
  </table>

</div>`,
  mounted: function() {
    store.commit('title', 'Seller')
    this.instance = 'seller'
    this.read_front()
  }
})

Vue.component('product', {
  mixins: [crud, crud_front],
  template: `
<div>

<table class="table">
<tr>
  <th>Code</th>
  <th>Name</th>
  <th>Price</th>
  <th>Warehouse</th>
</>
<tr v-for="row in data">
  <td>{{row.code}}</td>
  <td>{{row.name}}</td>
  <td>{{row.price}}</td>
  <td>{{row.warehouse}}</td>
</tr>
</table>

</div>`,
  mounted: function() {
    store.commit('title', 'Product')
    this.instance = 'product'
    this.read_front()
  }
})
