Vue.component('client', {
  mixins: [crud, crud_front],
  data: function () {
    return {
        current_row: this.current_row,
        form_data: this.form_data
    }
  },
  template: `
<div>

  <div v-if="data">
    <button @click="form_data = {'id':-1, 'name':'', phone:'', 'address':''}" class="btn btn-outline-primary float-right mb-1"><i class="fas fa-plus-square"></i> Create</button>
    <standard-table
      perpage="10"
      :rows="data"
      :current_row="current_row"
      :fields="[
          {name:'id', 'title': 'Id', type:'number', sort: true},
          {name:'name', 'title': 'Name', type:'string', sort: true},
          {name:'phone', 'title': 'Phone', type:'string', sort: true},
          {name:'address', 'title': 'Address', type:'string', sort: true}
      ]"
      :actions="[
          {name:'edit', caption:'', title: ' Edit', action: 'edit', class: 'fas fa-edit text-primary fa-icon-900'},
          {name:'delete', caption:'', title: 'Delete', action: 'delete', class: 'fas fa-eraser text-danger fa-icon-900'}
      ]"
      perpage="10"
      @select="selectRow($event)"
      @edit="editRow($event)"
      @delete="delete_front($event); form_data = null"
    />

    <div v-if="form_data">
      <md-dialog :md-active.sync="form_data" class="p-2" style="width: auto">
        <h2>Client</h2>
        <standard-form
            :data="form_data"
            :fields="[
                {name:'id', 'title': 'Id', type:'number'},
                {name:'name', 'title': 'Name', type:'string', placeholder: 'Enter name'},
                {name:'phone', 'title': 'Phone', type:'string'},
                {name:'address', 'title': 'Address', type:'string'}
            ]"
            :actions="[
                {name:'submit', title: 'Save', action: 'Save', class: '', dafault: true},
                {name:'cancel', title: 'Cancel', action: 'Cancel', class: ''}
            ]"
            @action="doAction($event)"
        />
      </md-dialog>
    </div>
  </div>
  <div v-else>
    Loading...
  </div>

</div>`,
  mounted: function() {
    store.commit('title', 'Client')
    this.instance = 'client'
    this.read_front()
  },
  methods: {
    selectRow: function (row) {
        this.current_row = row
    },
    editRow: function (row) {
      this.read_back(row, (one_row) => {
        this.form_data = one_row
      })
    },
    doAction: function($event) {
        if ($event.action.name == 'cancel') {
            this.form_data = null
        }
        if ($event.action.name == 'submit') {
            if ($event.row.id > 0) {
                this.update_front($event.row)
                this.form_data = null
            }
            else {
                this.create_front($event.row)
                this.form_data = null
            }
        }
    }
  }
})

app.componentsLoaded('client')