Vue.component('app-menu', {
  data: function () {
	return {
		sections: this.sections
	}
  },
  template: `
<nav class="col-md-2 d-none d-md-block bg-light sidebar">
  <div v-if="sections" class="sidebar-sticky">
    <span v-for="section in sections">
      <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
        <span>{{section.section}}</span>
        <a class="d-flex align-items-center text-muted" href="#"></a>
      </h6>
      <ul class="nav flex-column">
        <a v-for="item in section.items" class="nav-link" :href="item.path">{{item.item}}</a>
      </ul>
    </span>
  </div>
</nav>
`,
mounted: function () {
  this.sections = [
    {
    "section": "Main menu",
        "items": [
            {
              "item": "Default",
              "path": "#/"
            },
            {
                "item": "Сlient",
                "path": "#/client"
            },
            {
                "item": "Seller",
                "path": "#/seller"
            }
        ]
    },

    {
    "section": "Secondary menu",
        "items": [
            {
                "item": "Product",
                "path": "#/product"
            }
        ]
    }
  ]
}
})

Vue.component('default', {
  template: `
<div>

<h2>Пример №1 из 13</h2>
<p>Пример простого приложения с использованием роутов и Vuex.Store.</p>

</div>`,
  mounted: function() {
    store.commit('title', 'Default')
  }
})

Vue.component('client', {
  template: `
<div>

Client component

</div>`,
  mounted: function() {
    store.commit('title', 'Client')
  }
})


Vue.component('seller', {
  template: `
<div>

Seller component

</div>`,
  mounted: function() {
    store.commit('title', 'Seller')
  }
})

Vue.component('product', {
  template: `
<div>

Product component

</div>`,
  mounted: function() {
    store.commit('title', 'Product')
  }
})
