"use strict";

var vuesvg = {
  data: function () {
    return {
      ready: this.ready
    }
  },
  mounted: function() {
    this.ready = false
  },
  methods: {
    draw: function () {
      this.ready = true
    },
    saveSvg: function (fileName) {
      let svgEl = this.$refs.svg
      svgEl.setAttribute("xmlns", "http://www.w3.org/2000/svg")
      let svgData = svgEl.outerHTML
      let preface = '<?xml version="1.0" standalone="no"?>'
      let svgBlob = new Blob([preface, svgData], {type:"image/svg+xml;charset=utf-8"})
      let svgUrl = URL.createObjectURL(svgBlob)
      let downloadLink = document.createElement("a")
      downloadLink.href = svgUrl
      downloadLink.download = fileName
      document.body.appendChild(downloadLink)
      downloadLink.click()
      document.body.removeChild(downloadLink)
    }
  }
}
