Vue.component('v-style', {
  render: function (createElement) {
    return createElement('style', this.$slots.default)
  }
});
  
Vue.component('size-lines', {
  props:['sizeline'],
  computed: {
    pints: function () {
      let alpha_rad = Math.atan2((this.sizeline.y2 - this.sizeline.y1), (this.sizeline.x2 - this.sizeline.x1))
      let alpha = 180 * alpha_rad / Math.PI
      let p1 = {'x': this.sizeline.x1, 'y': this.sizeline.y1}
      let p2 = {'x': this.sizeline.x2, 'y': this.sizeline.y2}
      let p3 = {'x': this.sizeline.x1 + this.sizeline.offset * Math.sin(alpha_rad), 'y': this.sizeline.y1 - this.sizeline.offset * Math.cos(alpha_rad)}
      let p4 = {'x': this.sizeline.x2 + this.sizeline.offset * Math.sin(alpha_rad), 'y': this.sizeline.y2 - this.sizeline.offset * Math.cos(alpha_rad)}
      let p5 = {'x': p3.x+(p4.x-p3.x)/2 + 1*Math.sin(alpha_rad), 'y': p3.y+(p4.y-p3.y)/2 - 1*Math.cos(alpha_rad) }
      return { 'alpha': alpha, 'p1': p1, 'p2': p2, 'p3': p3, 'p4': p4, 'p5': p5 }
    }
  },
  template: `
  <g fill="none" stroke="black">
    <line class="sizeline" :x1="pints.p1.x" :y1="pints.p1.y" :x2="pints.p3.x" :y2="pints.p3.y" />
    <line class="sizeline" :x1="pints.p2.x" :y1="pints.p2.y" :x2="pints.p4.x" :y2="pints.p4.y" />
    <line class="sizeline" :x1="pints.p3.x" :y1="pints.p3.y" :x2="pints.p4.x" :y2="pints.p4.y" marker-start="url(#DimPoint1)" marker-end="url(#DimPoint2)" />
    <text class="sizetext" :x="pints.p5.x"  :y="pints.p5.y" text-anchor="middle" :transform="'rotate(' + pints.alpha + ', ' + pints.p5.x + ', ' + pints.p5.y +')'" v-html="sizeline.text"></text>    
  </g>
`
});
  