// USAGE: <svg-sector size="32" degrees="120" sectorcolor="#ff5733" sectorwidth="30" text="1" textcolor="#ff5733" textsize="7em" />
Vue.component('svg-sector', {
    props:['size', 'circlecolor', 'circlefill', 'degrees', 'sectorcolor', 'sectorwidth', 'text', 'textcolor', 'textsize'],
    computed: {
      dValue: function () {
        let degrees = parseInt(this.degrees)
        let d = 'M' + this.center + ',' + this.stroke / 2
        // Arc angles
        let firstAngle = degrees > 180 ? 90 : degrees - 90
        let secondAngle = -270 + degrees - 180

        // Arcs
        let firstArc = this.getArc(firstAngle)
        let secondArc = degrees > 180 ? this.getArc(secondAngle) : ''
        d = d + ' ' + firstArc + ' ' + secondArc
        return d
      },
      circleRadius: function () {
        let radius = (this.boxSize - this.stroke) / 2
        if (isNaN(radius)) {
            return 0
        }
        else {
            return radius
        }
      },
      circleFill: function () {
        return (typeof this.circlefill !== 'undefined') ? this.circlefill: 'none'
      },
      circleColor: function () {
        return (typeof this.circlecolor !== 'undefined') ? this.circlecolor: '#DDD'
      },
      sectorColor: function () {
        return (typeof this.sectorcolor !== 'undefined') ? this.sectorcolor: '#bD2828'
      },
      textColor: function () {
        return (typeof this.textcolor !== 'undefined') ? this.textcolor: '#bD2828'
      },
      textSize: function () {
        return (typeof this.textsize !== 'undefined') ? this.textsize: '5em'
      }
    },
    data: function () {
      return {
        stroke: this.stroke,
      }
    },
    template: `
  <svg :width="size + 'px'" :height="size + 'px'" viewBox="0 0 200 200">
    <circle :stroke-width="stroke" :fill="circleFill" :stroke="circleColor" cx="100" cy="100" :r="circleRadius"></circle>
    <path :stroke-width="stroke" fill="none" :stroke="sectorColor" :d="dValue"></path>
    <text text-anchor="middle" dominant-baseline="central" x="100" y="100" :font-size="textSize" :fill="textColor" v-html="text"></text>
  </svg>
  `,
  mounted: function () {
    this.boxSize = 200
    this.stroke =  (typeof this.sectorwidth !== 'undefined') ? this.sectorwidth: 20
    this.center = this.boxSize / 2
    this.radius = this.center - this.stroke / 2
  },
  methods: {
    radians: function (degrees) {
      return degrees / 180 * Math.PI;
    },
    getArc: function (angle) {
      let x = this.center + this.radius * Math.cos(this.radians(angle));
      let y = this.center + this.radius * Math.sin(this.radians(angle));
      return 'A' + this.radius + ',' + this.radius + ' 1 0 1 ' + x + ',' + y;
    }
  }
  })
