/*
 * user_code.c
 *
 *  Created on: 21 . 2020 .
 *      Author: andre
 */
#include "motorcontrol.h"
# include "stdlib.h"

#define SPEED_MAX	MAX_APPLICATION_SPEED_RPM
#define SPEED_MIN	0

#define POT_MAX		4000
#define POT_START	200
#define POT_STOP	50
#define POT_SPEED_ARRAY_SIZE	4
#define POT_SPEED_DELTA	100

int32_t POT_SPEED;
int32_t POT_SPEED_ARRAY[POT_SPEED_ARRAY_SIZE];
int32_t POT_SPEED_AVERAGE;
int32_t POT_SPEED_INDEX;

void Potentiometer_Init() {
	uint8_t i;
	for (i=0; i<POT_SPEED_ARRAY_SIZE; i++) {
		POT_SPEED_ARRAY[i] = 0;
	}
	POT_SPEED_INDEX=0;
	POT_SPEED = 0;
}

void Potentiometer_Process() {
	uint8_t i;

	POT_SPEED_ARRAY[POT_SPEED_INDEX] = SPEED_MIN + ( (SPEED_MAX-SPEED_MIN) / (POT_MAX-POT_STOP) ) * ((int32_t)ADC3->DR - POT_STOP);
	POT_SPEED_INDEX++;
	if (POT_SPEED_INDEX>=POT_SPEED_ARRAY_SIZE) {
		POT_SPEED_INDEX=0;
	}
	POT_SPEED_AVERAGE = 0;
	for (i=0; i<POT_SPEED_ARRAY_SIZE; i++) {
		POT_SPEED_AVERAGE = POT_SPEED_AVERAGE + POT_SPEED_ARRAY[i];
	}
	POT_SPEED_AVERAGE = POT_SPEED_AVERAGE/POT_SPEED_ARRAY_SIZE;

	if ( abs(POT_SPEED_AVERAGE - POT_SPEED) > POT_SPEED_DELTA) {
		POT_SPEED = POT_SPEED_AVERAGE;
		MC_ProgramSpeedRampMotor1((int16_t)(POT_SPEED/6), 100);
	}

	if( ADC3->DR > POT_START ) {
		if (MC_GetSTMStateMotor1() != RUN) {
		  MC_StartMotor1();
		}
	}
	else {
		if( ADC3->DR < POT_STOP ) {
			if (MC_GetSTMStateMotor1() == RUN) {
		  	  MC_StopMotor1();
			}
		}
	}
}
