import Vue from 'vue'
import Router  from 'vue-router'

import Login from '@/components/Login'
import Logout from '@/components/Logout'
import LogoutAll from '@/components/LogoutAll'
import Oauth from '@/components/Oauth'
import InstancePage from '@/components/InstancePage'
import InstanceEdit from '@/components/InstanceEdit'

const Default = () => import(
  /* webpackChunkName: "default" */ '@/components/Default.vue'
);

const Product = () => import(
  /* webpackChunkName: "product" */ '@/components/Product.vue'
);

Vue.use(Router)

export default new Router({
  routes: [
  { path: '/',
    component: Default
  },
  { path: '/default',
    component: Default, props: { dataurl: "InfoDeposite" }
  },
  { path: '/login',
    component: Login
  },
  { path: '/logout',
    component: Logout
  },
  { path: '/logout-all',
    component: LogoutAll
  },
  { path: '/oauth/:provider/:code',
    component: Oauth
  },
  { path: '/product',
    component: Product, props: { instance_set: "product" }
  },
  { path: '/product/prm/:prm',
    component: Product, props: { instance_set: "product" }
  },
  { path: '/:instance',
    component: InstancePage
  },
  { path: '/:instance/prm/:prm',
    component: InstancePage
  },
  { path: '/:instance/:id',
    component: InstanceEdit
  }
  ]
})