import store from '../store/store'
import appDataset from '../dataset/dataset'
import app from '../common/app'

export default {
  computed: {
    instance_name() {
      return this.getRouteParam('instance')
    },
    ID: function () {
      return this.getRouteParam('id')
    },
  },
  mounted: function() {
    this.init()
  },
  methods: {
    init: function () {
      this.instance = this.instance_name
      store.commit('title', appDataset[this.instance]['title'])
      this.instance_url = appDataset[this.instance]['url']

      let row = {id: this.ID}
      this.data = {}
      this.read_back(row, (response)=> {
          this.data = response
        },
        (errors) => {
          this.show_error(errors)
        }
      );

      this.load_ext_data()
    },
    doAction: function ($event) {
      if ($event.action.name == 'submit') {
        if ($event.valid == true) {
          if (this.ID == 0) {
            this.create_back(this.data, ()=> {
              app.notify({type: 'success', message: 'Created successfully'})
              this.$router.go(-1)
            }, (response)=> {
              this.show_error(response.errors)
            })
          }
          else {
            this.update_back(this.data, ()=> {
              app.notify({type: 'success', message: 'Saved successfully'})
              this.$router.go(-1)
            }, (response)=> {
              this.show_error(response.errors)
            })
          }
        }
        else {
          app.alert('Form is NOT valid!', '<i class="fas fa-times-circle text-danger"></i> Error')
        }
      }
      if ($event.action.name == 'cancel') {
        this.$router.go(-1)
      }
    },
    show_error: function(errors) {
      let message = errors.join('<br>')
      app.alert(message, '<i class="fas fa-times-circle text-danger"></i> Error')
    },

    getRouteParam: function (name) {
      return this.$route.params[name]
    },
  },
  watch: {
    ID() {
      this.init()
    },
    instance_name() {
      this.data = null
      this.init()
    }
  }
}
