# pip install --upgrade google-api-python-client google-auth-httplib2 google-auth-oauthlib

from oauthlib.oauth2 import WebApplicationClient
import requests
import json
from urllib.parse import unquote
from urllib.parse import urlparse, parse_qs

class gaOAuth:
    def __init__(self, id, secret, redirect_uri):
        self.id = id
        self.secret = secret
        self.redirect_uri = redirect_uri

        self.DISCOVERY_URL = ("https://accounts.google.com/.well-known/openid-configuration")
        self.google_provider_cfg = requests.get(self.DISCOVERY_URL).json()

        self.authorization_endpoint = self.google_provider_cfg["authorization_endpoint"]
        self.token_endpoint = self.google_provider_cfg["token_endpoint"]
        self.userinfo_endpoint = self.google_provider_cfg["userinfo_endpoint"]

        self.client = WebApplicationClient(self.id)
        self.auth_uri = self.client.prepare_request_uri(
            self.authorization_endpoint,
            redirect_uri = self.redirect_uri,
            scope = ["email"],
            access_type = "offline",
            include_granted_scopes = "true"
        )

    def get_token(self, authorization_response, code):
        token_url, headers, body = self.client.prepare_token_request(
            self.token_endpoint,
            authorization_response = authorization_response,
            redirect_url = self.redirect_uri,
            access_type = "offline",
            code = code
        )

        token_response = requests.post(
            token_url,
            headers = headers,
            data = body,
            auth = (self.id, self.secret)
        )
        return token_response

    def get_user_info(self, token_response):
        if token_response.status_code != 200:
            return None
        self.client.parse_request_body_response(json.dumps(token_response.json()))
        uri, headers, body = self.client.add_token(self.userinfo_endpoint)
        userinfo_response = requests.get(uri, headers=headers, data=body)
        return userinfo_response

    def get_user_id(self, user_info):
        if (user_info != None):
            user_info = user_info.json()
            if user_info.get("email_verified") == True:
            	users_email = user_info["email"]
            	return users_email

    def get_auth_uri(self):
        return self.auth_uri

