#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
#===============================================================================
# COUNTRIES
#===============================================================================
class Countries(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	name = db.Column(db.Text)
	code = db.Column(db.Text)
	flag_img = db.Column(db.Text)

	def __init__(self, data):
		for field in data:
			setattr(self, field, data.get(field))

# Countries_schema
class CountriesSchema(ma.Schema):
    class Meta:
        fields = ('id', 'name', 'code', 'flag_img')

# Schema's initializing
country_schema = CountriesSchema()
countries_schema = CountriesSchema(many = True)
#===============================================================================
