#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
#===============================================================================
# CLIENT
#===============================================================================
class Client(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	name = db.Column(db.Text)
	phone = db.Column(db.Text)
	address = db.Column(db.Text)
	country_id = db.Column(db.Integer)

	def __init__(self, data):
		for field in data:
			setattr(self, field, data.get(field))

# Client_schema
class ClientSchema(ma.Schema):
    class Meta:
        fields = ('id', 'name', 'phone', 'address', 'country_id')

# Schema's initializing
client_schema = ClientSchema()
clients_schema = ClientSchema(many = True)
#===============================================================================
