#!/usr/bin/python3
# -*- coding: utf-8 -*-

from flask import jsonify
import json
import os
import codecs

class Access:
	def __init__(self):
		# Load access.json file
		access_json = 'access.json'
		self.access_attr = {}
		if os.path.isfile(access_json):
			with codecs.open(access_json, 'r', 'utf-8') as file_data:
				self.access_attr = json.load(file_data)

	def check(self, request, model, user, groups):
		access_users = []
		access_groups = []
		if model in self.access_attr:
			if request.method in self.access_attr[model]:
				if 'users' in self.access_attr[model][request.method]:
					access_users = self.access_attr[model][request.method]['users']
				if 'groups' in self.access_attr[model][request.method]:
					access_groups = self.access_attr[model][request.method]['groups']

		# allow user
		if user in access_users or '*' in access_users:
			return True

		for group in groups:
			# allow group
			if group in access_groups:
				return True

		return False
