import appDataset from '../dataset/dataset'

export default {
  appDataset,
  data : function () {
    return {
      ext_data: this.ext_data
    }
  },
  computed: {
    form_fields: function () {
      let fields = appDataset[this.instance]['fields']['form']
      for (let field of fields) {

        // Prepare @select fields
        if (field['type'] == 'select') {
          if (field['dataset']) {
            field.items = []
            if (field['dataset']['src']) {
              if (this.ext_data[field['dataset']['src']]) {
                let src = this.ext_data[field['dataset']['src']]
                for (let item of src) {
                  field.items.push({value: item[field['dataset']['value']], caption: item[field['dataset']['caption']]})
                }
              }
            }
          }
        }

      }
      return fields
    }
  },
  mounted: function() {
    this.ext_data = []
  },
  methods: {
    load_ext_data: function() {
      let fields = appDataset[this.instance]['fields']['form']
      for (let field of fields) {
        if (field.dataset) {
          if (field.dataset.src) {
            this.read_ext_data(field.dataset.src)
          }
        }
      }
    },
    read_ext_data: function(instance) {
      let url = appDataset[instance]['url']
      let options = {method: 'GET'}
      this.fetch_execute(url, options,
        (response)=>{
          this.$set(this.ext_data, instance, response)
        },
        (response)=>{
          this.show_error(response.errors)
        }
      )
    }
  }
}
