import Fingerprint2 from 'fingerprintjs2'

export default class JWTClass {
  constructor(refreshUrl) {

    this.refreshUrl = refreshUrl
    this.refresh = false

    let access_token = localStorage.getItem('access_token')
    this.access_token = access_token?access_token:''

    let refresh_token = localStorage.getItem('refresh_token')
    this.refresh_token = refresh_token?refresh_token:''

    let sessionid = localStorage.getItem('sessionid')
    this.sessionid = sessionid?sessionid:''

    if (typeof Fingerprint2 !== 'undefined') {
      new Fingerprint2.get((result)=> {
        this.sessionid = result
        localStorage.setItem('sessionid', result)
      });
    }
  }

  tokensParse(token) {
    let base64Url = token.split('.')[1]
    let base64 = base64Url.replace(/-/g, '+').replace(/_/g, '/')
    let jsonPayload = decodeURIComponent(atob(base64).split('').map(function(c) {
        return '%' + ('00' + c.charCodeAt(0).toString(16)).slice(-2)
    }).join(''))
    return JSON.parse(jsonPayload)
  }

  tokensSave() {
    localStorage.setItem('access_token', this.access_token)
    localStorage.setItem('refresh_token', this.refresh_token)
  }

  tokensDelete() {
    this.access_token = ''
    this.refresh_token = ''
    localStorage.removeItem('access_token')
    localStorage.removeItem('refresh_token')
  }

  tokensSet(access_token, refresh_token) {
    this.access_token = access_token
    this.refresh_token = refresh_token
    this.tokensSave()
  }

  tokenIsExpired () {
    try {
      let JwtToken = this.tokensParse(this.access_token)
      let timeInS = Math.round(Date.now() / 1000)
      let JwtTokenIsExpired = timeInS > JwtToken.exp
      return JwtTokenIsExpired
    }
    catch (error) {
      return true
    }
  }

  async tokenRefresh () {
    if (this.refresh_token == '') {
      return false
    }
    else {
      this.refresh = true
      let options = {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8',
          'Authorization': 'Bearer ' + this.refresh_token,
          'sessionid': this.sessionid
        },
        body: ''
      }

      let response = await fetch(this.refreshUrl, options)
      if (response.status == 200) {
        let result = await response.json()
        //this.access_token = result['access_token']
        //this.refresh_token = result['refresh_token']
        //this.tokensSave()
        this.tokensSet(result['access_token'], result['refresh_token'])
        this.refresh = false
        return true
      }
      else {
        this.refresh = false
        return false
      }
    }
  }

  sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms))
  }

  async tokenCheck() {
    if (this.tokenIsExpired() == true) {
      if (this.refresh == false) {
        let result = await this.tokenRefresh()
        return result
      }
      else {
        let counter = 100
        while ( (this.refresh == true) && ( counter > 0) ) {
          await this.sleep(10)
          counter--
        }
        return true
      }
    }
    else {
      return true
    }
  }

}
