# pip install --upgrade google-api-python-client google-auth-httplib2 google-auth-oauthlib

from oauthlib.oauth2 import WebApplicationClient
import requests
import json
from urllib.parse import unquote, urlparse, parse_qs
#from urllib.parse import urlparse, parse_qs

class fbOAuth:
    def __init__(self, id, secret, redirect_uri):
        self.id = id
        self.secret = secret
        self.redirect_uri = redirect_uri

        self.authorize_url = "https://graph.facebook.com/oauth/authorize"
        self.access_token_url = "https://graph.facebook.com/oauth/access_token"
        self.base_url = "https://graph.facebook.com/"

        self.client = WebApplicationClient(self.id)

        self.auth_uri = self.client.prepare_request_uri(
            self.authorize_url,
            redirect_uri = self.redirect_uri,
            scope = "email"
        )

    def get_token(self, authorization_response, code):
        token_url, headers, body = self.client.prepare_token_request(
            self.access_token_url,
            authorization_response = authorization_response,
            redirect_url = self.redirect_uri,
            code = code
        )

        token_response = requests.post(
            token_url,
            headers=headers,
            data=body,
            auth=(self.id, self.secret),
        )
        return token_response

    def get_user_info(self, token_response):
        if token_response.status_code != 200:
            return None
        self.client.parse_request_body_response(json.dumps(token_response.json()))
        uri, headers, body = self.client.add_token(self.base_url + 'me/')
        userinfo_response = requests.get(uri, headers=headers, data=body)
        return userinfo_response

    def get_user_id(self, user_info):
        if (user_info != None):
            user_info = user_info.json()
            return user_info.get("name")

    def get_auth_uri(self):
        return self.auth_uri


