#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
import hashlib
#===============================================================================
# USERS
#===============================================================================
class Users(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	login = db.Column(db.Text)
	password = db.Column(db.Text)
	name = db.Column(db.Text)
	oauth_provider = db.Column(db.Text)

	def __init__(self, data):
		self.update(data)

	def update(self, data):
		for field in data:
			new_value = data.get(field)
			if field == 'password': # Special for Password
				if (self.password != new_value): # Replace if changed
					new_value = hashlib.md5(new_value.encode()).hexdigest()

			setattr(self, field, new_value)


# Users_schema
class UsersSchema(ma.Schema):
    class Meta:
        fields = ('id', 'login', 'password', 'name', 'oauth_provider')

# Schema's initializing
user_schema = UsersSchema()
users_schema = UsersSchema(many = True)
#===============================================================================

