#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
#===============================================================================
# TOKEN
#===============================================================================
class Token(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	login = db.Column(db.Text)
	devid = db.Column(db.Text)
	jti = db.Column(db.Text)
	refresh_token = db.Column(db.Text)
	exp = db.Column(db.Integer)

	def __init__(self, data):
		for field in data:
			setattr(self, field, data.get(field))

# Token_schema
class TokenSchema(ma.Schema):
    class Meta:
        fields = ('id', 'login', 'devid', 'jti', 'refresh_token', 'exp')

# Schema's initializing
token_schema = TokenSchema()
tokens_schema = TokenSchema(many = True)
#===============================================================================
