#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
#===============================================================================
# GROUPS
#===============================================================================
class Groups(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	name = db.Column(db.Text)
	users = db.Column(db.Text)

	def __init__(self, data):
		for field in data:
			setattr(self, field, data.get(field))

# Groups_schema
class GroupsSchema(ma.Schema):
    class Meta:
        fields = ('id', 'name', 'users')

# Schema's initializing
group_schema = GroupsSchema()
groups_schema = GroupsSchema(many = True)
#===============================================================================
