import store from '../store/store'
import app from '../common/app'

export default {
  app,
  store,
  data : function () {
    return {
      data: this.data,
      instance: this.instance,
      instance_url: this.instance_url,

      instance_search: this.instance_search,
      instance_order: this.instance_order,
      instance_paginator: this.instance_paginator,
      data_rows_count: this.data_rows_count,
    }
  },
  methods: {
    goToLogin: function () {
      if (this.$route.path != '/login') {
        store.commit('routeBeforeLgin', this.$route.path)
        app.navigate('/login')
      }
    },

    fetch_execute: async function (url, options, callbackOK, callbackError) {
      await app.JWT().tokenCheck()
      //if (JWT.access_token == '' || JWT.refresh_token == '') {
      //  this.goToLogin()
      //  return
      //}
      try {
        // Add token into header
        let token_header = {'Authorization': 'Bearer ' + app.JWT().access_token, 'sessionid': app.JWT().sessionid}
        if (typeof options['headers'] == 'undefined') {
          options['headers'] = {}
        }
        options['headers'] =  Object.assign(options['headers'], token_header)
        //

        let response = await fetch(url, options)
        if ((response.status == 401) || (response.status == 422)) {
          this.goToLogin()
        }
        else {
          let result = await response.json()
          if (typeof result.errors == 'undefined') {
            if (callbackOK) {
              callbackOK(result)
            }
          }
          else {
            if (callbackError) {
              callbackError(result)
            }
          }
        }
      }
      catch (error) {
        if (callbackError) {
          callbackError({'errors':[error]})
        }
      }
//      finally {
//      }
    },
    create_back: function (row, callbackOK, callbackError) {
      let url = this.instance_url
      let options = {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json;charset=utf-8'
        },
        body: JSON.stringify(row)
      }
      this.fetch_execute(url, options, callbackOK, callbackError)
    },
    read_back: function (row, callbackOK, callbackError) {

      let url = this.instance_url
      if (row) {
        url += row.id.toString() + '/'
      }
      else {
        let data = {}
        if (typeof this.instance_search != 'undefined'){
          Object.assign(data, this.instance_search)
        }
        if (typeof this.instance_order != 'undefined'){
          Object.assign(data, this.instance_order)
        }
        if (typeof this.instance_paginator != 'undefined'){
          Object.assign(data, this.instance_paginator)
        }
        let params = JSON.stringify(data)
        if (params != '{}') {
          url += params
        }
      }
      let options = {
        method: 'GET',
      }
      this.fetch_execute(url, options, callbackOK, callbackError)
    },
    update_back: async function (row, callbackOK, callbackError) {
      let url = this.instance_url + row.id.toString() + '/'
      let options = {
        method: 'PUT',
        headers: {
          'Content-Type': 'application/json;charset=utf-8'
        },
        body: JSON.stringify(row)
      }
      this.fetch_execute(url, options, callbackOK, callbackError)
    },
    delete_back: async function (row, callbackOK, callbackError) {
      let url = this.instance_url + row.id.toString() + '/'
      let options = {
        method: 'DELETE',
        headers: {
          'Content-Type': 'application/json;charset=utf-8'
        }
      }
      this.fetch_execute(url, options, callbackOK, callbackError)
    }
  }
}
