import router from '../router/router'
import store from '../store/store'
import Vue from 'vue'
import VuejsDialog from 'vuejs-dialog'
import VuejsDialogMixin from 'vuejs-dialog/dist/vuejs-dialog-mixin.min.js'
import 'vuejs-dialog/dist/vuejs-dialog.min.css'

Vue.use(VuejsDialog)
Vue.use(VuejsDialogMixin)

export default {
  router,
  store,

  getRouteParam: function (name) {
    return router.app.$route.params[name]
  },

  navigate: function (path) {
    if (router.history.current.path != path) {
      router.push(path)
    }
  },

  alert: function (massage, title = null) {
      let options = {
        html: true,
        okText: 'OK',
        type: 'basic',
        backdropClose: true
      }
      if (title !== null) {
        massage = '<div class="h4 mn pn mb5">' + title + '</div>' + massage
      }
      return Vue.dialog.alert(massage, options)
  },

  confirm: function (massage) {
    let options = {
      html: true,
      animation: 'zoom',
      okText: 'OK',
      cancelText: 'Cancel',
      type: 'basic',
      backdropClose: true
    }
     return Vue.dialog.confirm(massage, options)
  },

  notify: function (notification) {
    router.app.notify(notification)
  },

  JWT: function () {
    return router.app.JWT
  },

  reloadID: function (id) {
    store.commit('reloadID', id)
  },

  loadSettings: function () {
    let settings_text = localStorage.getItem('appSettings')
    if (settings_text == '' ) {
      settings_text = null
    }
    let settings = JSON.parse(settings_text)
    if (settings == null) {
      settings = {}
    }
    return settings
  },

  saveSettings: function(settings) {
    localStorage.setItem('appSettings', JSON.stringify(settings))
  },

  getSettings: function (path, defaultValue = null) {
    let settings = this.loadSettings()

    if (settings == null) {
      return defaultValue
    }
    else {
      try {
        let keys = path.split('.')
        let obj = settings
        for (let key of keys) {
          if (typeof obj[key] != 'undefined') {
            obj = obj[key]
          }
          else {
            return defaultValue
          }
        }
        return obj
      }
      catch (e) {
        return defaultValue
      }
    }
  },

  setSettings: function (path, value) {
    let settings = this.loadSettings()
    let keys = path.split('.')
    let obj = {}
    let cur_obj = obj
    for (let i=0; i<keys.length-1; i++) {
      cur_obj[keys[i]] = {}
      cur_obj = cur_obj[keys[i]]
    }
    cur_obj[keys[keys.length-1]] = value
    settings = Object.assign(settings, obj)
    this.saveSettings(settings)
  }

}
