import Vuex from 'vuex'
import Vue from 'vue'

Vue.use(Vuex)

export default new Vuex.Store({
  state: {
    title: '',
    userName: '',
    routeBeforeLgin: '',
    reloadID: {menu:0, current:0}
 },
  mutations: {
    title (state, value) {
      state.title = value
    },
    userName (state, value) {
      state.userName = value
    },
    routeBeforeLgin (state, value) {
      state.routeBeforeLgin = value
    },
    reloadID (state, id) {
      if (typeof state.reloadID[id] != 'undefined') {
        state.reloadID[id] += 1
      }
    }
  }
})
