import store from '../store/store'
import appDataset from '../dataset/dataset'
import app from '../common/app'

export default {
  app,
  store,
  appDataset,
  props:['instance_set'],
  data: function () {
    return {
      orderField: this.orderField,
      orderReverse: this.orderReverse,
      search: this.search,
      current_row: this.current_row
    }
  },
  computed: {
    prm: function() {
      try {
        return JSON.parse(atob(this.getRouteParam('prm')))
      }
      catch (e) {
        return null
      }
    },
    prm_new: function() {
      let obj = {}
      obj['paginator'] = this.instance_paginator['paginator']
      obj['order'] = this.instance_order['order']
      obj['search'] = this.instance_search['search']
      return btoa(JSON.stringify(obj))
    },
    instance_name() {
      if (this.getRouteParam('instance')) {
        return this.getRouteParam('instance')
      }
      else {
        //return this.instance
	return this.instance_set
      }
    },
    fields: function () {
      return appDataset[this.instance]['fields']['table']
    },
    sortFields: function () {
      let fields = []
      for (let field of this.fields) {
          if ( (typeof field.sort !== 'undefined') && (typeof field.name !== 'undefined') && (typeof field.title !== 'undefined') && (typeof field.type !== 'undefined') ){
              fields.push({field:field.name, caption:field.title, type:field.type})
          }
      }
      return fields
    },
    paginator_pages() {
      return Math.ceil(this.data_rows_count/this.perpage)
    },
    paginator_page() {
      try {
        let page = this.prm['paginator']['page']
        return parseInt(page)
      }
      catch (e) {
        return 1
      }
    },
  },
  mounted: function() {
    this.orderField = ''
    this.orderReverse = false
    this.search = ''
    this.init()
  },
  methods: {
    init: function() {
      this.instance = this.instance_name
      store.commit('title', appDataset[this.instance]['title'])
      this.instance_url = appDataset[this.instance]['url']
      if (appDataset[this.instance]['perpage']) {
        this.perpage = appDataset[this.instance]['perpage']
      }

      this.instance_paginator = {'paginator':{'page':1, 'limit':this.perpage}}
      this.instance_order = {}
      this.instance_search = {}
      if (this.prm) {
        this.instance_paginator['paginator'] = this.prm['paginator']
        this.instance_order['order'] = this.prm['order']
        this.instance_search['search'] = this.prm['search']

        if (this.prm['order']) {
          if (this.prm['order'].length > 0) {
            let order_prm = this.prm['order'][0].split(' ')
            this.orderField = order_prm[0]
            this.orderReverse = (order_prm.length > 1)
          }
        }

        if (this.prm['search']) {
          for (let item of this.prm['search']) {
            let keys = Object.keys(item)
            if (keys.length > 0) {
              this.search = item['value']
            }
            break;
          }
        }

      }

      this.data = []
      this.read_front()

      if (this.datasets) {
        this.datasets_array = []
        for (let ext_data of this.datasets) {
          this.read_ext_data(ext_data)
          this.datasets_array.push(ext_data)
        }
      }
    },

    applayNewPrm: function () {
      app.navigate('/'+ this.instance + '/prm/' + this.prm_new)
    },
    order: function (field) {
      if (this.orderField === field) {
        if (this.orderReverse) {
          // disable order
          this.orderField = ''
        }
        else {
          this.orderReverse = true
        }
      }
      else {
        this.orderField = field
        //this.orderFieldType = type
        this.orderReverse = false
      }

      if (this.orderField == '') {
        this.instance_order = {}
      }
      else {
        this.instance_order = {"order": [this.orderField + (this.orderReverse==true?" desc":"")]}
      }
      this.applayNewPrm()
    },

    searchApply: function (searchText) {
      this.search = searchText
      let searchArray = []
      for (let field of this.fields) {
        searchArray.push({'field': field.name, 'value': this.search, 'operator': 'LIKE'})
      }
      this.instance_search = {"search":searchArray}
      this.instance_paginator['paginator']['page'] = 1
      this.applayNewPrm()
    },

    selectRow: function(row) {
        this.current_row = row
    },
    addRow: function() {
      app.navigate('/'+ this.instance + '/0')
    },
    editRow: function(row) {
      app.navigate('/'+ this.instance +'/' + row.id)
    },
    setPage: function(page) {
      if (page < 1) page = 1
      if (page > this.paginator_pages) page = this.paginator_pages
      this.instance_paginator['paginator']['page'] = page
      this.applayNewPrm()
    }, 
    setPrevPage: function() {
      this.setPage(this.paginator_page -1)
    },
    setNextPage: function() {
      this.setPage(this.paginator_page +1)
    },
    getRouteParam: function (name) {
      return this.$route.params[name]
    },
  },
  watch: {
    prm() {
      this.init()
    },
    instance_name() {
      this.init()
    },
  }
}
