import app from '../common/app'

export default {
    app,
    methods: {
        create_front: function (row) {
            this.create_back(row, ()=> {
              this.read_front() // Reloads all data after creating one record... Not so good idea. But...
              app.notify({type: 'success', message: 'Created successfully'})
            },
            (response)=> {
              this.show_error(response.errors)
            })
          },

          read_front: function (row) {
            this.read_back(row, (response)=> {
              if ('errors' in response) {
                this.show_error(response.errors)
              }
              else {
                if (row) {
                  // update one row
                  for (let key in response) {
                    row[key] = response[key]
                  }
                }
                else {
                  // update data
                  this.data = response

                  ///////// new
                  // get _total_records_ and Remove record with _total_records_ from data
                  this.data_rows_count = this.data.length
                  if (typeof this.data[this.data.length-1]['_total_records_'] != 'undefined') {
                    this.data_rows_count = this.data[this.data.length-1]['_total_records_']
                    this.data = this.data.slice(0, this.data.length-1)
                  }
                  /////////
                }
              }
            },
            (response)=> {
              this.show_error(response.errors)
            })
          },
          update_front: function (row) {
            this.update_back(row, ()=> {
                this.read_front(row)
                app.notify({type: 'success', message: 'Saved successfully'})
            },
            (response)=> {
              this.show_error(response.errors)
            })
          },
          delete_front: function (row) {
            app.confirm('Delete ?').then(()=> {
              this.delete_back(row, ()=> {
                this.data.splice(this.data.indexOf(row), 1)
                app.notify({type: 'success', message: 'Deleted successfully'})
              },
              (response)=> {
                this.show_error(response.errors)
              });
            }).catch( function () {
            })
          },
          show_error: function(errors) {
            let message = errors.join('<br>')
            app.alert(message, '<i class="fas fa-times-circle text-danger"></i> Error')
          }
    }
}
