export default {
  'menu':{
    'instance': 'menu',
    'url': 'http://localhost:5000/menu/',
  },
  'client': {
    'instance': 'client',
    'title': 'Client',
    'perpage': 5,
    'url': 'http://localhost:5000/client/',
    'fields': {
      'table': [
        {name:'name', 'title': 'Name', type:'string', sort: true},
      ],
      'form': [
//        {name:'id', 'title': 'ID', type:'number', min:-1, max:100, step:1},
        {name:'name', 'title': 'Name', type:'string', placeholder: 'Enter name', maxlength: 20, required: true},
        {name:'phone', 'title': 'Phone', type:'string'},
        {name:'address', 'title': 'Address', type:'textarea'},
        {name:'country_id', 'title': 'Country', type:'select', dataset: {src: 'countries', value: 'id', caption: 'name'}},
/*
        {name:'email', 'title': 'Email', type:'email', pattern: '[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$'},
        {name:'password', 'title': 'Password', type:'password'},
        {name:'photo', 'title': 'Photo', type:'file', accept:'image/*'},
        {name:'country', 'title': 'Country', type:'select', items:[{value:1, caption:'Ukraine'},{value:2, caption:'USA'},{value:3, caption:'Canada'}]},
        {name:'address', 'title': 'Address', type:'textarea'},
        {name:'birthday', 'title': 'Birthday', type:'date'},
        {name:'married', 'title': 'Married', type:'switch'},
        {name:'sex', 'title': 'Sex', type:'radio', items:[{value:1, caption:'male'},{value:2, caption:'female'},{value:3, caption:'undefined'}]},
        {name:'married', 'title': 'Married', type:'checkbox'},
        {name:'tags', 'title': 'Tags', type:'chips'},
*/
      ]
    }
  },

  'seller': {
    'instance': 'seller',
    'title': 'Seller',
    'perpage': 5,
    'url': 'http://localhost:5000/seller/',
    'fields': {
      'table': [
        {name:'name', 'title': 'Name', type:'string', sort: true},
        {name:'phone', 'title': 'Phone', type:'string', sort: true},
        {name:'email', 'title': 'E-mail', type:'string', sort: true}
      ],
      'form': [
        {name:'name', 'title': 'Name', type:'string'},
        {name:'phone', 'title': 'Phone', type:'string'},
        {name:'email', 'title': 'E-mail', type:'string'}
      ]
    }
  },

  'product': {
    'instance': 'product',
    'title': 'Product',
    'perpage': 10,
    'url': 'http://localhost:5000/product/',
    'fields': {
      'table': [
        {name:'code', 'title': 'Code', type:'string', sort: true},
        {name:'name', 'title': 'Name', type:'string', sort: true},
        {name:'price', 'title': 'Price', type:'number', sort: true},
        {name:'warehouse', 'title': 'Warehouse', type:'string', sort: true}
      ],
      'form': [
        {name:'code', 'title': 'Code', type:'string', required:true},
        {name:'name', 'title': 'Name', type:'string', required:true},
        {name:'price', 'title': 'Price', type:'number', step: 0.01, min:0, required:true},
        {name:'warehouse', 'title': 'Warehouse', type:'autocomplete', items:[1,2], required:true},
        {name:'comment', 'title': 'Comment', type:'textarea'},
    ]
    }
  },
  'countries': {
    'instance': 'countries',
    'title': 'Countries',
    'perpage': 5,
    'url': 'http://localhost:5000/countries/',
    'fields': {
      'table': [
        {name:'name', 'title': 'Name', type:'string', sort: true},
        {name:'flag_img', 'title': 'Flag', type:'string', sort: false},
      ],
      'form': [
        {name:'name', 'title': 'Name', type:'string', required:true},
        {name:'code', 'title': 'Code', type:'string', required:true},
        {name:'flag_img', 'title': 'Flag', type:'string', required:false},
	    ]
    }
  },
  'login': {
   'instance': 'login',
    'title': 'Login',
    'perpage': 5,
    'url': 'http://localhost:5000/auth/login/',
    'fields': {
      'form': [
        {name:'login', 'title': 'Login', type:'string', required:true},
        {name:'password', 'title': 'Password', type:'password', required:true}
	    ]
    }
  },
  'refresh': {
    'url': 'http://localhost:5000/auth/refresh/'
  },
  'logout': {
    'url': 'http://localhost:5000/auth/logout/'
  },
  'logout-all': {
    'url': 'http://localhost:5000/auth/logout-all/'
  },
  'users': {
    'instance': 'users',
    'title': 'Users',
    'perpage': 5,
    'url': 'http://localhost:5000/users/',
    'fields': {
      'table': [
        {name:'login', 'title': 'Login', type:'string', sort: true},
        {name:'name', 'title': 'Name', type:'string', sort: true}
      ],
      'form': [
        {name:'login', 'title': 'Login', type:'string', required:true},
        {name:'password', 'title': 'Password', type:'password', required:true},
        {name:'name', 'title': 'Name', type:'string'}
	    ]
    }
  },
  'groups': {
    'instance': 'groups',
    'title': 'Groups',
    'perpage': 5,
    'url': 'http://localhost:5000/groups/',
    'fields': {
      'table': [
        {name:'name', 'title': 'Group', type:'string', sort: true},
        {name:'users', 'title': 'Users', type:'string', sort: true}
      ],
      'form': [
        {name:'name', 'title': 'Group', type:'string', required:true},
        {name:'users', 'title': 'Users', type:'textarea'}
	    ]
    }
  },
}
