#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
#===============================================================================
# SELLER
#===============================================================================
class Seller(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	name = db.Column(db.Text)
	phone = db.Column(db.Text)
	email = db.Column(db.Text)

	def __init__(self, data):
		for field in data:
			setattr(self, field, data.get(field))

# Seller_schema
class SellerSchema(ma.Schema):
    class Meta:
        fields = ('id', 'name', 'phone', 'email')

# Schema's initializing
seller_schema = SellerSchema()
sellers_schema = SellerSchema(many = True)
#===============================================================================
