#!/usr/bin/python3
# -*- coding: utf-8 -*-

from app import db, ma
#===============================================================================
# PRODUCT
#===============================================================================
class Product(db.Model):
	id = db.Column(db.Integer, primary_key = True)
	name = db.Column(db.Text)
	code = db.Column(db.Text)
	price = db.Column(db.Float)
	warehouse = db.Column(db.Text)

	def __init__(self, data):
		for field in data:
			setattr(self, field, data.get(field))

# Product_schema
class ProductSchema(ma.Schema):
    class Meta:
        fields = ('id', 'name', 'code', 'price', 'warehouse')

# Schema's initializing
product_schema = ProductSchema()
products_schema = ProductSchema(many = True)
#===============================================================================
