Vue.component('logout', {
    mixins: [crud, crud_front],
    template: `
<div>
</div>`,
    mounted: function() {
        this.instance = 'logout'
        this.instance_url = appDataset[this.instance]['url']
        this.read_back(null, ()=>{
            JWT.tokensDelete()
            store.commit('userName', '')
            app.reloadID('menu')
            app.navigate('/login')
        })        
    }
})

Vue.component('logout-all', {
    mixins: [crud, crud_front],
    template: `
<div>
</div>`,
    mounted: function() {
        this.instance = 'logout-all'
        this.instance_url = appDataset[this.instance]['url']
        this.read_back(null, ()=>{
            JWT.tokensDelete()
            store.commit('userName', '')
            app.reloadID('menu')
            app.navigate('/login')
        })
    }
})

Vue.component('login', {
    mixins: [crud, crud_front],
    data: function() {
        return {
            login: this.login,
            password: this.password,
        }
    },
    template: `
<div>
    <h1>Login</h1>

    <standard-form v-if="instance"
      :data="{'login': login, 'password':password}"
      :fields="appDataset[instance]['fields']['form']"
      :actions="[
          {name:'login', title: 'Login', action: 'Login', class: '', dafault: true},
          {name:'cancel', title: 'Cancel', action: 'Cancel', class: ''}
      ]"
      @action="doAction($event)"
    />

</div>`,
    mounted: function() {
        this.instance = 'login'
        this.instance_url = appDataset[this.instance]['url']
        store.commit('title', appDataset[this.instance]['title'])
        this.login = ''
        this.password = ''
    },
    methods: {
        doAction: function(event) {
            if (event.valid == true) {
                if (event.action['name'] == 'login') {
                    let submit_data = {'login': event.row['login'], 'password': event.row['password']}
                    this.create_back(submit_data, (response)=> {
                        if (response['access_token'] && response['refresh_token']) {
                            JWT.tokensSet(response['access_token'], response['refresh_token'])
                            access_token = JWT.tokensParse(response['access_token'])
                            store.commit('userName', access_token['user_claims']['name'])

                            app.reloadID('menu')
                            app.notify({type: 'success', message: 'Loginned'})
                            if (store.state.routeBeforeLgin == '') {                            
                                app.navigate('/')
                            }
                            else {
                                app.navigate(store.state.routeBeforeLgin)                                
                            }
                        }
                        else {
                            if (response['errors']) {
                                this.show_error(response['errors'])
                            }
                            else {
                                this.show_error(['Unknown error'])
                            }
                        }
                    },
                    (response)=> {
                        this.show_error(response.errors)
                    })
                }
            }
        },
    }
})

app.componentsLoaded('login')
app.componentsLoaded('logout')
app.componentsLoaded('logout-all')
