Vue.component('product', {
  mixins: [crud, crud_front, crud_ext, paginator_server],
  data: function () {
    return {
      filters: this.filters,
      currentFilter: this.currentFilter,
      perpageAray: this.perpageAray
    }
  },
  template: `
<div>
  <div v-if="data">
    <button @click="addRow()" class="btn btn-outline-primary float-right mb-1"><i class="fas fa-plus-square"></i> Create</button>
<hr>
  <div class="m-3">
    Sort by (variant #1): 
    | <span v-for="filter in filters"><a @click="currentFilter=filter" :class="currentFilter==filter?'font-weight-bold':''">{{filter.caption}}</a> | </span>
  </div>

  <div class="m-3">
    Sort by (variant #2):
    <select v-model="currentFilter">
      <option></option>
      <option v-for="filter in filters" :value="filter">{{filter.caption}}</option>
    </select>
  </div>

<hr>
    <product-table
      :rows="data"
      :current_row="current_row"
      @select="selectRow($event)"
      @removeRow="removeRow($event)"
      @update="update_front($event)"
      @create="create_front($event)"
      @read="read_front($event)"
      @delete="delete_front($event)"
      />

<paginator v-bind:pages="paginator_pages" gap="5" v-bind:currentPage="paginator_page" v-on:setPage="setPage($event)" v-on:setPrevPage="setPrevPage()" v-on:setNextPage="setNextPage()" class="text-center"></paginator>

    <div>On page: 
      | <span v-for="item in perpageAray">
          <a @click="setPerPage(item)" :class="perpage==item?'font-weight-bold':''">{{item}}</a> | 
        </span>
    </div>
    <div>
      <i>Parameter 'On page' stored in the application settings.</i>
    </div>

<hr>

  </div>
</div>`,
mounted: function () {
  this.filters = [
    {'caption':'Name', 'field':'name', 'reverse': false},
    {'caption':'Price', 'field':'price', 'reverse': false},
    {'caption':'Price reverse', 'field':'price', 'reverse': true}
  ]

  this.currentFilter = null
  for (filter of this.filters) {
    if ( (filter['field'] == this.orderField) && (filter['reverse'] == this.orderReverse) ){
      this.currentFilter = filter
      break
    }
  }

  this.perpageAray = [2, 3, 4, 6, 8, 12]

  this.perpage =  app.getSettings('produсt.perpage', 8)
  appDataset[this.instance]['perpage'] = this.perpage

},
methods: {
  addRow: function () {
    this.data.push({'_edit_': true})
  },

  removeRow: function (row) {
    this.data.splice(this.data.indexOf(row), 1)
  },

  setPerPage: function (item) {
    appDataset[this.instance]['perpage'] = item
    this.instance_paginator = {'paginator':{'page':1, 'limit':item}}
    app.setSettings('produсt.perpage', item)
    this.applayNewPrm()
  }
},
watch: {
  currentFilter() {
    if (this.currentFilter) {
      this.instance_order = {"order": [this.currentFilter['field'] + (this.currentFilter['reverse']==true?" desc":"")]}
      this.applayNewPrm()
    }
    else {
      this.instance_order = {}
      this.applayNewPrm()
    }
  }
}
})


Vue.component('product-table', {
  mixins:[table],
  template: `
<div>

  <div class="row">
    <div class="card float-left m-4" v-for="row in rows" style="width: 18rem;" @click="$emit('select', row)" :class="current_row==row?'bg-dark text-white':''">
      <template v-if="row._edit_ == true">
        <div class="card-header">
          Code: <input type="text" v-model="row.code" size="15" required>
          <a @click="cancelEdit(row)" title="Cancel" class="float-right"><i class="fas fa-undo-alt"></i></a>
          <a @click="updateRow(row)" title="Save" class="float-right mr-2"><i class="fas fa-save text-success"></i></a>
        </div>
        <div class="card-body">
          <h5 class="card-title"><input type="text" v-model="row.name" style="width:100%" required></h5>
          <p class="card-text">$ <input type="number" step="0.01" v-model="row.price" required></p>
        </div>
      </template>
      <template v-else>
        <div class="card-header">
          Code: {{row.code}}
          <a @click="deleteRow(row)" title="Delete" class="float-right ml-2"><i class="fas fa-times text-danger"></i></a>
          <a @click="$set(row, '_edit_', true)" title="Edit" class="float-right"><i class="fas fa-edit"></i></a>
        </div>
        <div class="card-body">
          <h5 class="card-title">{{row.name}}</h5>
          <p class="card-text">$ {{row.price}}</p>
        </div>
      </template>

    </div>
  </div>

</div>
  `,
methods: {
  updateRow: function (row) {
    row._edit_= null                // first disable edit mode
    this.$nextTick(()=> {           // then update view
      delete row._edit_             // after redrawing delete unnecessary field (_edit_)
      if (row.id) {
        this.$emit('update', row)   // finnaly update row
      }
      else {
        this.$emit('create', row)   // finnaly create row
      }
    })
  },
  deleteRow: function (row) {
    this.$emit('delete', row)
  },
  cancelEdit: function (row) {
    row._edit_= null
    this.$nextTick(()=> {
      delete row._edit_
      if (row.id) {
        this.$emit('read', row)
      }
      else {
        this.$emit('removeRow', row) // remove new record
      }
    })
  }
}
})

app.componentsLoaded('product')
