from flask import jsonify
from functools import wraps
import json
import os
import codecs

class access:
	def __init__(self, connection):
		# Load access.json file
		access_json = 'access.json'
		self.access_attr = {}
		if os.path.isfile(access_json):
			with codecs.open(access_json, 'r', 'utf-8') as file_data:
				self.access_attr = json.load(file_data)

		# Load groups from DB
		from model import groups
		groups = groups.model(connection)
		rows = groups.read()
		self.group_users = []
		for row in rows:
			users_list = []
			for user in row['users'].split(','):
				users_list.append(user)
			self.group_users.append({'name': row['name'], 'users':users_list})

	def check(self, request, model, user):
		access_users = []
		access_groups = []
		if model in self.access_attr:
			if request.method in self.access_attr[model]:
				if 'users' in self.access_attr[model][request.method]:
					access_users = self.access_attr[model][request.method]['users']
				if 'groups' in self.access_attr[model][request.method]:
					access_groups = self.access_attr[model][request.method]['groups']

		# allow user
		if user in access_users or '*' in access_users:
			return True

		for group in self.group_users:
			if user in group['users']:
				# allow group
				if group['name'] in access_groups:
					return True

		return False
