import sqlite3

conn = sqlite3.connect('myApp.db')
cur = conn.cursor()

print ("Opened database successfully")

conn.execute('''CREATE TABLE COUNTRIES
	(id		INTEGER PRIMARY KEY AUTOINCREMENT    NOT NULL,
	name		TEXT,
	code		TEXT,
	flag_img	TEXT
	);''')

print ("Table created successfully")

#############################
# Insert Data into table COUNTRIES
#############################

countries = [
        {'id':1, 'name': 'Ukraine', 'code':'380', 'flag_img': 'ua.png'},
	{'id':2, 'name': 'USA', 'code':'380', 'flag_img': 'us.png'},
	{'id':3, 'name': 'France', 'code':'33', 'flag_img': 'fr.png'}
]

for item in countries:
	SQL = 'INSERT INTO COUNTRIES (id, name, code, flag_img) VALUES({0}, "{1}", "{2}", "{3}")'.format(item['id'], item['name'], item['code'], item['flag_img'])
	cur.execute(SQL)

print ("Table 'COUNTRIES' is done")


conn.execute('''ALTER TABLE CLIENT ADD COLUMN country_id INTEGER;''')
print ("Table CLIENT modified successfully")

conn.execute('''CREATE INDEX IF NOT EXISTS client_country_id ON CLIENT (country_id)''')
print ("Index created successfully")

conn.commit()

print ("Commit is done")

conn.close()

print ("Database is closed")
print ("Good luck!")
