#!/usr/bin/python3
# -*- coding: utf-8 -*-

from flask import Flask, flash, session, request, Response, send_from_directory, render_template, jsonify

import sqlite3
connection = sqlite3.connect('myApp.db', check_same_thread=False)


app = Flask(__name__, template_folder='templates')
app.secret_key = 'ASA:VTMJI~ZvPOS8W:0L2cAb?WB}R0V_'

##############################
# Static files
############################## 
@app.route('/frontend/')
def send_frontend_index():
	return send_from_directory('frontend/', 'index.html')

@app.route('/frontend/<path:path>')
def send_frontend_files(path):
	return send_from_directory('frontend/', path)

##############################
# Main Page
##############################
@app.route('/', methods=['GET'])
def home_page():
	return render_template('index.html'), 200


##############################
# Client
##############################
@app.route('/client/', methods=['POST'])
def client_create():
	cursor = connection.cursor()
	SQL = 'INSERT INTO CLIENT (name, phone, address) VALUES("{0}", "{1}", "{2}")'.format(request.json['name'], request.json['phone'], request.json['address'])
	try:
		cursor.execute(SQL)
		connection.commit()
		result = {'result':'OK', 'id':cursor.lastrowid}
	except Exception:
		result = {'result':'ERROR'}
	finally:
		return jsonify(result), 200

@app.route('/client/', methods=['GET'])
def client_read_all():
	cursor = connection.cursor()
	cursor.execute('SELECT * FROM CLIENT;')
	field_names = list(map(lambda x: x[0], cursor.description))
	rows = cursor.fetchall()
	records = []
	for row in rows:
		field_i = 0
		record = {}
		for field in field_names:
			record[field] = row[field_i]
			field_i += 1
		records.append(record)

	return jsonify(records), 200

@app.route('/client/<int:id>/', methods=['GET'])
def client_read(id):
	cursor = connection.cursor()
	cursor.execute('SELECT * FROM CLIENT WHERE(id={0});'.format(id))
	field_names = list(map(lambda x: x[0], cursor.description))
	rows = cursor.fetchall()
	record = {}
	for row in rows:
		field_i = 0
		for field in field_names:
			record[field] = row[field_i]
			field_i += 1

	return jsonify(record), 200

@app.route('/client/<int:id>/', methods=['PUT'])
def client_update(id):
	cursor = connection.cursor()
	SQL = 'UPDATE CLIENT SET name="{1}", phone="{2}", address="{3}" WHERE(id={0});'.format(id, request.json['name'], request.json['phone'], request.json['address'])
	try:
		cursor.execute(SQL)
		connection.commit()
		result = {'result':'OK'}
	except Exception:
		result = {'result':'ERROR'}
	finally:
		return jsonify(result), 200

@app.route('/client/<int:id>/', methods=['DELETE'])
def client_delete(id):
	cursor = connection.cursor()
	SQL = 'DELETE FROM CLIENT WHERE(id={0});'.format(id)
	try:
		cursor.execute(SQL)
		connection.commit()
		result = {'result':'OK'}
	except Exception:
		result = {'result':'ERROR'}
	finally:
		return jsonify(result), 200

##############################
# Error Pages
##############################

@ app.errorhandler(404)
def err_404(error):
	return render_template('error.html', message='Page not found'), 404

@ app.errorhandler(500)
def err_500(error):
	return render_template('error.html', message='Internal server error'), 500

##############################
# Logging configure
##############################
if not app.debug:
	import logging
	from logging.handlers import RotatingFileHandler
	file_handler = RotatingFileHandler('log/my_app.log', 'a', 1 * 1024 * 1024, 10)
	file_handler.setFormatter(logging.Formatter('%(asctime)s %(levelname)s: %(message)s [in %(pathname)s:%(lineno)d]'))
	app.logger.setLevel(logging.INFO)
	file_handler.setLevel(logging.INFO)
	app.logger.addHandler(file_handler)
	app.logger.info('startup')

##############################
# Run app
##############################

if __name__ == '__main__':
	app.run(host='0.0.0.0')

