#!/usr/bin/python3
# -*- coding: utf-8 -*-

from flask import Flask, flash, session, request, Response, send_from_directory, render_template, jsonify

app = Flask(__name__, template_folder='templates')
app.secret_key = 'ASA:VTMJI~ZvPOS8W:0L2cAb?WB}R0V_'

##############################
# Client array
############################## 
client = [
        {'id':1, 'name': 'Atomuli Yadalato', 'phone': '+5010674373431', 'address': 'Syracuse, 2528  Oak Street'},
        {'id':2, 'name': 'Sovseiduri Oherachu', 'phone': '+2290504407434', 'address': '2671  Oakmound Drive'},
        {'id':3, 'name': 'Matzal Cats', 'phone': '+387664683394', 'address': '2172  Ella Street'},
        {'id':4, 'name': 'Yatasuka Nakomode', 'phone': '+380504457494', 'address': '163  Moore Avenue'},
        {'id':5, 'name': 'Fire-Bow de Bleu', 'phone': '+359504467844', 'address': '3813  Kenwood Place'},
        {'id':6, 'name': 'Hans Trachenbürger', 'phone': '+210504455773', 'address': '1008  Broadway Avenue'},
        {'id':7, 'name': 'Bzdashek Zapadlovsky', 'phone': '+2265046234714', 'address': '1083  Woodland Terrace'},
        {'id':8, 'name': 'Thanos Slyunidopolu', 'phone': '+6840504670154', 'address': '2529  Briarhill Lane'},
        {'id':9, 'name': 'Kheranuka Poroyalu', 'phone': '+855504456780', 'address': '4751  Corbin Branch Road'},
        {'id':10, 'name': 'Ushat Pomoev', 'phone': '+235504453457', 'address': '1960  Gore Street'},
        {'id':11, 'name': 'Harem Playboys', 'phone': '+357504462859', 'address': '81  Monroe Avenue'},
        {'id':12, 'name': 'Marazmus Nolemotsiy', 'phone': '+620506379083', 'address': '1245  Duff Avenue'},
        {'id':13, 'name': 'Orido Pota', 'phone': '+200567890432', 'address': '2091  Braxton Street'},
        {'id':14, 'name': 'Olivier Ju yes Swallow', 'phone': '+500453268901', 'address': '4940  Chardonnay Drive'},
        {'id':15, 'name': 'Rucishchito Shirehari', 'phone': '+3585345628972', 'address': '4069  Austin Secret Lane'},
        {'id':16, 'name': 'Stoyana Rakova', 'phone': '+490345246783', 'address': '349  Bombardier Way'},
        {'id':17, 'name': 'Spiro Napolnasrakis', 'phone': '+955412324306', 'address': '130  Smithfield Avenue'},
	{'id':18, 'name': 'Helga Schlucher', 'phone': '+910564738018', 'address': '1199  State Street'}
]

##############################
# Static files
############################## 
@app.route('/frontend/')
def send_frontend_index():
	return send_from_directory('frontend/', 'index.html')

@app.route('/frontend/<path:path>')
def send_frontend_files(path):
	return send_from_directory('frontend/', path)

##############################
# Main Page
##############################
@app.route('/', methods=['GET'])
def home_page():
	return render_template('index.html'), 200


##############################
# Client
##############################
@app.route('/client/', methods=['POST'])
def client_create():
	client.append(request.json)

	result = {'result':'OK'}
	return jsonify(result), 200

@app.route('/client/', methods=['GET'])
def client_read_all():
	return jsonify(client), 200

@app.route('/client/<int:id>/', methods=['GET'])
def client_read(id):
	result = {}
	for item in client:
		if item['id'] == id:
			result = item
			break

	return jsonify(result), 200

@app.route('/client/<int:id>/', methods=['PUT'])
def client_update(id):
	for i, item in enumerate(client):
		if item['id'] == id:
			client[i] = request.json
			break

	result = {'result':'OK'}
	return jsonify(result), 200

@app.route('/client/<int:id>/', methods=['DELETE'])
def client_delete(id):
	for i, item in enumerate(client):
		if item['id'] == id:
			client.remove(item)
			break

	result = {'result':'OK'}
	return jsonify(result), 200

##############################
# Error Pages
##############################

@ app.errorhandler(404)
def err_404(error):
	return render_template('error.html', message='Page not found'), 404

@ app.errorhandler(500)
def err_500(error):
	return render_template('error.html', message='Internal server error'), 500

##############################
# Logging configure
##############################
if not app.debug:
	import logging
	from logging.handlers import RotatingFileHandler
	file_handler = RotatingFileHandler('log/my_app.log', 'a', 1 * 1024 * 1024, 10)
	file_handler.setFormatter(logging.Formatter('%(asctime)s %(levelname)s: %(message)s [in %(pathname)s:%(lineno)d]'))
	app.logger.setLevel(logging.INFO)
	file_handler.setLevel(logging.INFO)
	app.logger.addHandler(file_handler)
	app.logger.info('startup')

##############################
# Run app
##############################

if __name__ == '__main__':
	app.run(host='0.0.0.0')

