#!/usr/bin/python3
# -*- coding: utf-8 -*-

from flask import Flask, flash, session, request, Response, send_from_directory, render_template

app = Flask(__name__, template_folder='templates')
app.secret_key = 'ASA:VTMJI~ZvPOS8W:0L2cAb?WB}R0V_'

##############################
# Static files
############################## 
@app.route('/frontend/')
def send_frontend_index():
	return send_from_directory('frontend/', 'index.html')

@app.route('/frontend/<path:path>')
def send_frontend_files(path):
	return send_from_directory('frontend/', path)

##############################
# Main Page
##############################
@app.route('/', methods=['GET'])
def home_page():
	return render_template('index.html'), 200

##############################
# Error Pages
##############################

@ app.errorhandler(404)
def err_404(error):
    return render_template('error.html', message='Page not found'), 404

@ app.errorhandler(500)
def err_500(error):
    return render_template('error.html', message='Internal server error'), 500

##############################
# Logging configure
##############################
if not app.debug:
    import logging
    from logging.handlers import RotatingFileHandler
    file_handler = RotatingFileHandler('log/my_app.log', 'a', 1 * 1024 * 1024, 10)
    file_handler.setFormatter(logging.Formatter('%(asctime)s %(levelname)s: %(message)s [in %(pathname)s:%(lineno)d]'))
    app.logger.setLevel(logging.INFO)
    file_handler.setLevel(logging.INFO)
    app.logger.addHandler(file_handler)
    app.logger.info('startup')

##############################
# Run app
##############################

if __name__ == '__main__':
     app.run(host='0.0.0.0')

