#include <stdio.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/wdt.h>

#include "delay.h"
#include "atmega_bmp180_lib.h"

#include "uart.h"
#define RXUBRR (F_CPU/16/9600)-1 //9600

static volatile unsigned char FLAG_REPLY;
static volatile unsigned char FLAG_TIMER;

static volatile unsigned char RXi;
static volatile unsigned char RXc;
#define RX_BUF_SIZE 64
static volatile unsigned char RXBuffer[RX_BUF_SIZE];

static volatile unsigned int TimerOneSec;


void clear_RXBuffer()
{
	for (RXi=0;RXi<RX_BUF_SIZE;RXi++)
		RXBuffer[RXi] = 0;
	RXi = 0;

	FLAG_REPLY = 0;
}

// This function called from uart.c file (* - Make better if you wish)
void RX_getc(unsigned char RXc) {
	if ((RXc != 255) && (RXc != 0) && (RXc != 10)) {
		if (RXc != 13) {
			RXBuffer[RXi] = RXc;
			RXi++;
			if (RXi > RX_BUF_SIZE-1) {
				clear_RXBuffer();
			}
			//uart_putc(RXc);
		}
		else {
			FLAG_REPLY = 1;
		}
	}
}

void uart_wite_char(char str) {
	while (RXc != str)
		RXc = uart_getc();
	
}

void uart_wite_for(const char * str) {
	char result = 0;

	while (result == 0) {
		FLAG_REPLY = 0;
		clear_RXBuffer();
		while (FLAG_REPLY == 0) {
		}
		result = strstr(RXBuffer, str);
	}
}

///////////////////////////////////////////
//--------------------------------------------------------
//  
//--------------------------------------------------------
// :
void adc_init(void){	

  //ADCSRA = _BV(ADEN) | _BV(ADPS0) | _BV(ADPS1); // prescaler = 128
  ADCSRA = _BV(ADEN) | _BV(ADPS0) | _BV(ADPS1) | _BV(ADPS2); // prescaler = 128

}


//  :

uint16_t adc_read(uint8_t ch){	
  ADMUX = _BV(REFS0) | (ch & 0x1F);	// set channel (VREF = VCC)	
  ADCSRA &= ~_BV(ADIF);			// clear hardware "conversion complete" flag	
  ADCSRA |= _BV(ADSC);			// start conversion	

  while(ADCSRA & _BV(ADSC));		// wait until conversion complete	

  return ADC;				// read ADC (full 10 bits);
}

ISR(TIMER2_COMP_vect)
{
	TimerOneSec++;
	if (TimerOneSec > 6000) {
		// RTESET
		cli();
		wdt_enable(WDTO_15MS);
		while(1);
	}
}


int main(void){	
	//OSCCAL += 10;

	unsigned char id;

	char buffer[30];
	char header_buffer[30];
	char resp_len;

	int32_t temperature = 0;
	int32_t pressure = 0;

	int16_t BMP180_calibration_int16_t[8];
	int16_t BMP180_calibration_uint16_t[3];
	uint8_t error_code=0;

	int humidity = 0;
	int light = 0;

	// Initialize TWI
	i2cSetBitrate(1000);
	// Initialize BMP180
	BMP180_Calibration(BMP180_calibration_int16_t, BMP180_calibration_uint16_t,&error_code);
	bmp180Convert(BMP180_calibration_int16_t, BMP180_calibration_uint16_t,&temperature, &pressure,&error_code);

	adc_init();

	//OCR2 = 37;// For 4 MHz
	OCR2 = 78;// For 8 MHz
	TCCR2 = (1<<WGM21)|(1<<CS22)|(1<<CS21)|(1<<CS20);
	TIMSK = (1<<OCIE2);	// Enable TC2.oc, interrupt
	TimerOneSec = 0;

	sei();

	uart_init(RXUBRR);
	
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);
	delay_ms(200);

	//uart_puts("AT+RST\r\n");
	//uart_wite_for("Ready");

	uart_puts("AT+CIPMODE=0\r\n");
	//uart_wite_for("OK");
	delay_ms(50);

	uart_puts("AT+CIPMUX=1\r\n");
	//uart_wite_for("OK");
	delay_ms(50);

	uart_puts("AT+CIPSERVER=1,88\r\n"); // Port 88
	//uart_wite_for("OK");
	delay_ms(50);

	uart_puts("AT+CIPSTO=3\r\n"); // Timeout
	//uart_wite_for("OK");
	delay_ms(50);

	while(1) {
		// Wait for Data
		uart_wite_for("+IPD");
		id = RXBuffer[5];

		uart_wite_for("OK");

		///// Write to Fuffer
		bmp180Convert(BMP180_calibration_int16_t, BMP180_calibration_uint16_t,&temperature, &pressure,&error_code);
		//: $Value = ($Vsuply*$ADC_VALUE/1023 - 0.63195) / 0.0205095;
		humidity = (int)(49*(330*(long int)adc_read(3)/1023 -63)/100);
		if (humidity < 0) {
			humidity = 0;
		}
		if (humidity > 100) {
			humidity = 100;
		}
		light = adc_read(2);

		sprintf(buffer, "P:%d:T:%d:H:%d:L:%d\r\n\0", (int)(pressure/100), (int)temperature, humidity, light);
		resp_len = strlen(buffer);
		///// Write to Fuffer

		uart_puts("AT+CIPSEND=");
		uart_putc(id);
		sprintf(header_buffer, ",%d\r\n\0", resp_len-1);
		uart_puts(header_buffer);

		uart_wite_char('>');


		//uart_puts("P:1000:T:024:H:085\r\n"); //length: 20
		uart_puts(buffer);

		uart_wite_for("OK");
		uart_puts("AT+CIPCLOSE=");
		uart_putc(id);
		uart_puts("\r\n");
		clear_RXBuffer();
	}
}
