#include <stdio.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>

#include "delay.h"

#include "uart.h"
#define RXUBRR (F_CPU/16/9600)-1 //9600
//#define RXUBRR (F_CPU/16/115202)-1 //115200

uint8_t  FLAG_REPLY;

uint8_t RXi;
char RXc;
#define RX_BUF_SIZE 64
static char RXBuffer[RX_BUF_SIZE];

#define LED_DDR		DDRB
#define LED_PORT	PORTB
#define LED_PIN		PINB0
#define LED_OFF		LED_PORT |= (1<<LED_PIN)
#define LED_ON		LED_PORT &= ~(1<<LED_PIN)

void clear_RXBuffer()
{
	for (RXi=0;RXi<RX_BUF_SIZE;RXi++)
		RXBuffer[RXi] = 0;
	RXi = 0;

	FLAG_REPLY = 0;
}

// This function called from uart.c file (* - Make better if you wish)
void RX_getc(unsigned char RXc) {
	if ((RXc != 255) && (RXc != 0) && (RXc != 10)) {
		if (RXc != 13) {
			RXBuffer[RXi] = RXc;
			RXi++;
			if (RXi > RX_BUF_SIZE-1) {
				clear_RXBuffer();
			}						
		}
		else {
			FLAG_REPLY = 1;
		}
	}
}

void uart_wite_char(char str) {
	while (RXc != str)
		RXc = uart_getc();
	
}

void uart_wite_for(const char * str) {
	char result = 0;

	while (result == 0) {
		FLAG_REPLY = 0;
		clear_RXBuffer();
		while (FLAG_REPLY == 0) {
		}
		result = strstr(RXBuffer, str);
	}
}

int main(void){	
	uint8_t id;

	// Init LED Port
	LED_DDR |= (1<<LED_PIN);
	LED_OFF;

	sei();

	uart_init(RXUBRR);
	
	delay_ms(500);

	uart_puts("AT+RST\r\n");
	uart_wite_for("Ready");

	uart_puts("AT+CIPMODE=0\r\n");
	uart_wite_for("OK");

	uart_puts("AT+CIPMUX=1\r\n");
	uart_wite_for("OK");

	uart_puts("AT+CIPSERVER=1,88\r\n"); // Port 88
	uart_wite_for("OK");

	uart_puts("AT+CIPSTO=5\r\n"); // Timeout
	uart_wite_for("OK");


	LED_ON;

	while(1) {
		// Wait for Data
		uart_wite_for("+IPD");
		id = RXBuffer[5];

		if (strstr(RXBuffer, "/info") > 0) {
		}

		if (strstr(RXBuffer, "/on") > 0) {
			LED_ON;
		}

		if (strstr(RXBuffer, "/off") > 0) {
			LED_OFF;
		}

		uart_wite_for("OK");

		uart_puts("AT+CIPSEND=");
		uart_putc(id);
		uart_puts(",176\r\n"); //176 - length of returned data (HTML reply size)

		uart_wite_char('>');


		uart_puts("HTTP/1.1 200 OK\r\n"); //length: 17
		uart_puts("Content-Type: text/html; charset=UTF-8\r\n\r\n"); //length: 42
		uart_puts("<html><head><title>Wi-Fi ESP8266 DEMO</title></head><body><a href=\"/on\">on</a> <a href=\"/off\">off</a></body></html>\r\n"); //length: 117
		uart_putc(id);

		//uart_wite_for("OK");
		//uart_puts("AT+CIPCLOSE=");
		//uart_putc(id);
		//uart_puts("\r\n");
	}
}
