#include <cstdlib>
#include <iostream>
#include <RF24/RF24.h>

using namespace std;

// gpio pins, spi speed
RF24 radio(RPI_V2_GPIO_P1_22, RPI_V2_GPIO_P1_24, BCM2835_SPI_SPEED_8MHZ);

typedef  struct
  {
    int8_t    value1;
    int8_t    value2;
    int8_t    text[14];
  } PAYLOAD;

PAYLOAD  receivePayload;

int main(int argc, char** argv)
{
  char bufferout[16];
  uint8_t pipe_num = 0;
  uint8_t state = 0;
  uint8_t counter = 0;

  radio.begin();
  radio.setPALevel(RF24_PA_MAX);
  radio.setDataRate(RF24_1MBPS);
  radio.setCRCLength(RF24_CRC_16);
  radio.setRetries(15, 15);
  radio.setAutoAck(1);
  radio.setChannel(76);
  radio.setPayloadSize(16);

  radio.openWritingPipe(0xE8E8F0F0E2LL);

  printf("Start\n");

  while(1) {
    if (state == 0) {
      // Send request
      printf("send request...\n");
      radio.openWritingPipe(0xE8E8F0F0E2LL);
      radio.write(bufferout,sizeof(bufferout));
      state = 1;
      counter = 0;
      // Start to Listening
      radio.startListening();
    }
    else {
      if (radio.available(&pipe_num)) {
        memset(receivePayload,0,sizeof(receivePayload));
        radio.read(&receivePayload, sizeof(receivePayload));
        printf("pipe %d: value1=%d value2=%d text=%s\n", pipe_num, receivePayload.value1, receivePayload.value2, receivePayload.text);
        state = 0;
        radio.stopListening();
      }
      delay(0.01);
      counter ++;
      if (counter > 200) {
        radio.stopListening();
        state = 0;
        printf("Nefiga :(\n");
      }
    }
    delay(1);
  }
  return 0;
}
