#include <cstdlib>
#include <iostream>
#include <RF24/RF24.h>

using namespace std;

// gpio pins, spi speed
RF24 radio(RPI_V2_GPIO_P1_22, RPI_V2_GPIO_P1_24, BCM2835_SPI_SPEED_8MHZ);

int main(int argc, char** argv)
{
  char receivePayload[16];
  uint8_t pipe_num=0;

  radio.begin();
  radio.setPALevel(RF24_PA_MAX);
  radio.setDataRate(RF24_1MBPS);
  radio.setCRCLength(RF24_CRC_16);
  radio.setRetries(15, 15);
  radio.setAutoAck(1);
  radio.setChannel(76);
  radio.setPayloadSize(16);
  radio.openReadingPipe(0,0xE8E8F0F0E2LL);
  radio.openReadingPipe(1,0xC1C2C2C2C2LL);
  radio.openReadingPipe(2,0xC1C2C2C2C3LL);
  radio.openReadingPipe(3,0xC1C2C2C2C4LL);
  radio.openReadingPipe(4,0xC1C2C2C2C5LL);
  radio.openReadingPipe(5,0xC1C2C2C2C6LL);

  radio.startListening();
  printf("Start\n");

  while(1) {
    while (radio.available(&pipe_num))
    {
      // Clear measurement values
      memset(receivePayload,0,sizeof(receivePayload));

      radio.read(&receivePayload, sizeof(receivePayload));
      printf("pipe %d: %s\n", pipe_num, receivePayload);
    }
  }
  return 0;
}

