#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include "uart/uart.h"
#define UART_BAUDRATE (F_CPU/16/9600)-1

#include "nrf24l01/nrf24l01.h"

int main(void) {
	uint8_t i = 0;
	uint8_t bufferin[NRF24L01_PAYLOAD+1];

	uart_init(UART_BAUDRATE);

	nrf24l01_init();

	//init interrupt
	sei();

	uart_puts("Starting as RX...\r\n");

	//reset buffer
	for(i=0; i<sizeof(bufferin); i++)
		bufferin[i] = 0;

	nrf24l01_printinfo(uart_puts, uart_putc);

	//main loop
	while(1) {
		uint8_t pipe = 0;
		if(nrf24l01_readready(&pipe)) { //if data is ready

			char pipebuffer[5];
			uart_puts("Pipe: ");
			itoa(pipe, pipebuffer, 10);
			uart_puts(pipebuffer);
			uart_puts("\r\n");

			//read buffer
			nrf24l01_read(bufferin);
			bufferin[NRF24L01_PAYLOAD] = '\0';
			uart_puts("Data: ");
			uart_puts(bufferin);
			uart_puts("\r\n");
				
			for(i=0; i<sizeof(bufferin); i++)
				bufferin[i] = 0;

		}
		_delay_ms(10);
	}
}




