#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include "uart/uart.h"
#define UART_BAUDRATE (F_CPU/16/9600)-1

#include "nrf24l01/nrf24l01.h"

typedef	struct
	{
		int8_t		value1;
		int8_t		value2;
		int8_t		text[14];
	} PAYLOAD;

int main(void) {
	uint8_t pipe = 0;
	uint8_t i;

	//uint8_t bufferout[NRF24L01_PAYLOAD];
	PAYLOAD	bufferout;
	uint8_t bufferin[NRF24L01_PAYLOAD];

	uart_init(UART_BAUDRATE);

	nrf24l01_init();

	//init interrupt
	sei();

	//setup buffer
	bufferout.value1 = 10;
	bufferout.value2 = 13;
	for(i=0; i<sizeof(bufferout.text); i++)
		bufferout.text[i] = i+'a';
	for(i=0; i<sizeof(bufferin); i++)
		bufferin[i] = 0;

	nrf24l01_printinfo(uart_puts, uart_putc);

	while(1) {
		if(nrf24l01_readready(&pipe)) { //if data is ready

			char pipebuffer[5];
			uart_puts("Pipe: ");
			itoa(pipe, pipebuffer, 10);
			uart_puts(pipebuffer);
			uart_puts("\r\n");

			//read buffer
			nrf24l01_read(bufferin);
			uart_puts("Data: ");
			uart_puts(bufferin);
			uart_puts("\r\n");
				
			for(i=0; i<sizeof(bufferin); i++)
				bufferin[i] = 0;

			_delay_us(10);
			//write buffer
			uint8_t writeret = nrf24l01_write(&bufferout);

			if(writeret == 1)
				uart_puts("OK\r\n");
			else
				uart_puts("Failed\r\n");

		}
	}
}




