#include <stdio.h>
#include <avr/interrupt.h>
#include "uart.h"

#define RXUBRR (F_CPU/16/9600)-1

#define BUFFER_SIZE 11
char buffer[BUFFER_SIZE];
unsigned long int card_code = 0;
char bit_count=0;

void convert_to_decimal(char* dst, unsigned long src) 
{     
    int i;
    for (i = 0; i < 10; i ++) 
    {         
        dst[9 - i] = '0' + (int)(src % 10);
        src /= 10;     
    }     

    dst[10] = 0; 
}


ISR(INT0_vect) {
	card_code = card_code << 1;
	bit_count++;
}

ISR(INT1_vect) {
	card_code = card_code << 1;
	card_code = card_code | 0x01;
	bit_count++;
}

int main( void )
{
  uart_init(RXUBRR);

  MCUCR |= (1<<ISC01); // INT0 (falling edge)
  MCUCR |= (1<<ISC11); // INT1 (falling edge)
  GICR = ((1<<INT0)|(1<<INT1)); // Enable INT0, INT1

  sei();
  uart_puts("Started\r\n");

  while(1) {
	if (bit_count == 26) {
		card_code = card_code >> 1;
		card_code = card_code & 0x00ffffff;
		
		uart_puts("Card number: ");

		convert_to_decimal(buffer, card_code);
		uart_puts(buffer);

		uart_puts("\r\n");

		card_code=0;
		bit_count=0;
	}
  }
}
