#include <stdio.h>
#include <string.h>
#include <avr/io.h>
#include <util/delay.h>

#include "arrow.h"

void arrow_init() {
	step0OUT[0] = ARROW_PIN1;
	step1OUT[0] = ARROW_PIN2;

	step0OUT[1] = ARROW_PIN3;
	step1OUT[1] = ARROW_PIN4;

	step0OUT[2] = ARROW_PIN2;
	step1OUT[2] = ARROW_PIN1;

	step0OUT[3] = ARROW_PIN4;
	step1OUT[3] = ARROW_PIN3;

	arrowUP(ARROW_STEPS);
	arrowDN(ARROW_STEPS);
	
	arrowStep = 0;
	arrowPos = 0;
}


void arrowUP(uint8_t steps){
	while(1) {
		ARROW_DDR |= (1<<step0OUT[arrowStep] | 1<<step1OUT[arrowStep]); //       
		ARROW_PORT |= (1<<step1OUT[arrowStep]); // +
		ARROW_PORT &= ~(1<<step0OUT[arrowStep]); // -
		_delay_ms(ARROW_DELAY);
		steps--;
		arrowStep++;
		if (arrowStep>3) {
			arrowStep=0;
		}
		if (steps == 0) {
			ARROW_DDR &= ~((1<<ARROW_PIN1) | (1<<ARROW_PIN2) | (1<ARROW_PIN3) | (1<<ARROW_PIN4)); //   (  "")
			return;
		}
	}
}


void arrowDN(uint8_t steps){
	while(1) {
		ARROW_DDR |= (1<<step0OUT[arrowStep] | 1<<step1OUT[arrowStep]); //       
		ARROW_PORT |= (1<<step0OUT[arrowStep]); // +
		ARROW_PORT &= ~(1<<step1OUT[arrowStep]); // -
		_delay_ms(ARROW_DELAY);
		steps--;
		if (arrowStep>0) {
			arrowStep--;
		}
		else {
			arrowStep=3;
		}
		if (steps == 0) {
			ARROW_DDR &= ~((1<<ARROW_PIN1) | (1<<ARROW_PIN2) | (1<ARROW_PIN3) | (1<<ARROW_PIN4)); //   (  "")
			return;
		}
	}
}

void arrowSetPos(uint8_t pos){
	if (pos == arrowPos) return;
	if (pos > ARROW_STEPS)
		pos = ARROW_STEPS;
	
	if (pos > arrowPos) {
		arrowUP(pos - arrowPos);
	}
	else {
		arrowDN(arrowPos - pos);
	}
	arrowPos = pos;
}
