#include <stdio.h>
#include <avr/io.h>
#include "lcd_lib.h"
#include "dht11.h"

char buffer[8];

int main( void )
{	 
	//  LCD
	LCDinit();

	//  
	LCDcursorOFF();
	
	//  
	LCDclr();  

	int8_t temperature = 0;
	int8_t humidity = 0;
	while(1) {
		humidity = dht11_gethumidity();
		temperature = dht11_gettemperature();

		LCDGotoXY(0,0);
		sprintf(buffer, "T=%02d", temperature);
		LCDstring(buffer,4);
		
		LCDGotoXY(0,1);
		sprintf(buffer, "H=%02d", humidity);
		LCDstring(buffer,4);

	}

}
