#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avr/io.h>
#include <math.h>
#include <avr/interrupt.h>
#include <util/delay.h>

#include "WG12864A.h"
#include "uart.h"
#include "gps.h"

#define RXUBRR (F_CPU/16/115200)-1 //115200

#define BUFFER_SIZE 50
char buffer[BUFFER_SIZE];

uint8_t FLAG_ONE_SEC;
double tmp_double;
uint8_t TimerOneSec = 0;

ISR(TIMER2_COMP_vect)
{
	TimerOneSec++;
	
	if (GPS.reading > 0)
		GPS.reading--;
	
	if (GPS.reading == 1) {
		gps_parse();
	}
	
	if (TimerOneSec > 99) {
		TimerOneSec = 0;
		FLAG_ONE_SEC = 1;
		
		if (GPS.plugged > 0)
			GPS.plugged--;
	}
}

typedef struct {
	unsigned long degree;
	unsigned long minute;
	unsigned long part;
	unsigned long part1;
	unsigned long part2;
	char		  c;
} tpGPS_pnt_parts;


void gps_split_to_parts (unsigned long gps_value, char gps_char, tpGPS_pnt_parts *pnt_parts) {
	pnt_parts->degree = floor(gps_value/1000000);
	pnt_parts->minute = floor((gps_value-pnt_parts->degree*1000000)/10000);
	pnt_parts->part = gps_value - (pnt_parts->degree*1000000) - (pnt_parts->minute*10000);
	pnt_parts->part1 = pnt_parts->part/100;
	pnt_parts->part2 = pnt_parts->part - pnt_parts->part1*100;
}

void gps_convert_to_format (uint8_t* _buffer, unsigned long gps_value, char c) {
  tpGPS_pnt_parts gps_parts;

	gps_split_to_parts(gps_value, c, &gps_parts);
	sprintf(_buffer, "%02u%c%02u.%04u", (unsigned int)gps_parts.degree, (char)127 ,(unsigned int)gps_parts.minute, (unsigned int)gps_parts.part);
	
	if (((uint8_t)c==0xFF) | ((uint8_t)c==0x00)) {
		_buffer[10] = ' ';
	}
	else {	
		_buffer[10] = c;
	}
}



int main(void){

	// init for GPS
	uart_init(RXUBRR);

	//  100 Hz
	//OCR2 = 37;// For 4 MHz
	OCR2 = 78;// For 8 MHz
	TCCR2 = (1<<WGM21)|(1<<CS22)|(1<<CS20);
	TIMSK = (1<<OCIE2);	//    

	sei();

	WG_init_lcd();
	WG_clear();

	//  .       .
	sprintf(GPS_Current_Point.name, " Point 1");
	GPS_Current_Point.latitude = 47034568;
	GPS_Current_Point.latitude_c = 'N';
	GPS_Current_Point.longitude = 31243322;
	GPS_Current_Point.longitude_c = 'E';


	while(1) {
		if (FLAG_ONE_SEC == 1) {
				WG_clear();
				if (GPS.plugged > 0) { // GPS -  
					if (GPS.actual > 0) { // GPS -      
						//
						gps_convert_to_format(buffer, GPS.latitude, GPS.latitude_c);
						WG_puts(0, 0, buffer, 11, 0);

						//
						gps_convert_to_format(buffer, GPS.longitude, GPS.longitude_c);
						WG_puts(0, 1, buffer, 11, 0);

						//
						dtostrf(GPS.altitude,4,0,buffer);
						WG_puts(1, 2, buffer, 4, 0);
						WG_puts(6, 2, "m", 6, 0);
				
						//
						dtostrf(GPS.speed,3,0,buffer);
						WG_puts_big(1, 4, buffer, 3, 0);
				
						//
						dtostrf(GPS.course,3,0,buffer);
						WG_puts_big(13, 4, buffer, 3, 0);

						// Current Point
						WG_puts(11, 0, GPS_Current_Point.name, 9, 255);

						dtostrf(gps_angle(),3,1,buffer);
						WG_puts(12, 2, buffer, 6, 0);
						
						tmp_double = gps_distance();
						if (tmp_double > 1000) {
							dtostrf(tmp_double,5,0,buffer);
						}
						else {
							dtostrf(tmp_double,3,3,buffer);
						}
						//WG_puts(13, 1, buffer, 6, 0);
						WG_puts(13, 1, buffer, 5, 0);
					}
					else {
						sprintf(buffer, "Connecting...");
						WG_puts(5, 1, buffer, 13, 0);
					}
				}
				else {
					sprintf(buffer, "GPS ERROR!");
					WG_puts(5, 1, buffer, 10, 0);
				}

			FLAG_ONE_SEC = 0;
		}
	}

}
