#ifndef	GPS_H
#define	GPS_H

#include <avr/io.h>

typedef	struct
{
	unsigned long	latitude; 		// 
	char			latitude_c; 	//  
	unsigned long	longitude;		//  
	char			longitude_c;	//  
	uint8_t			satels;			//  
	double			altitude;		//    
	double			geodeff;		//  
    double			Time;			// 
	uint8_t			Day;			// 
	uint8_t			Month;			// 
	unsigned int	Year;			// 
	double			course;			//    
	double			speed;			// 
	uint8_t			plugged;		// >0 - GPS  ; =0 - GPS   
	uint8_t			actual;			// GPS       
	uint8_t			reading;		//     
} tpGPG;

tpGPG	GPS;

// GPS Poit
typedef struct {
	unsigned long	latitude;		//  
	char			latitude_c;		//  
	unsigned long	longitude; 		// 
	char			longitude_c; 	//  
	char 			name [10];		//  
} tpGPG_Point;

tpGPG_Point GPS_Current_Point;		//        

//void gps_clear_RXBuffer(void);
void gps_getc(void);
void gps_init(void);
void gps_parse(void);
double gps_distance(void);
double gps_angle(void);
//double gps_convert_to_grad (unsigned long int GPS_DATA);
unsigned long int gps_convert_to_grad (unsigned long int GPS_DATA);

#endif

