#include <stdio.h>
#include <avr/io.h>
#include <string.h>

#include "WG12864A.h"
#include "delay.h"
#include "symbols.h"

#define SetBit(x,y) (x|=y)
#define ClrBit(x,y) (x&=~y)
#define TestBit(x,y) (x&y)
#define NOP() __asm__ volatile("nop");

void WG_WriteCom(unsigned char Com,unsigned char CS)
{ 
	#ifdef WG12864B
		ClrBit(LCD_COM,CS);
	#else
		SetBit(LCD_COM,CS);
	#endif
	ClrBit(LCD_COM,LCD_RS);
	ClrBit(LCD_COM,LCD_RW);
	NOP();
	NOP();
	LCD_DPORT=Com;
	SetBit(LCD_COM,LCD_E);
	NOP();
	NOP(); 
	ClrBit(LCD_COM,LCD_E);
	delay_us(4);
	#ifdef WG12864B
		SetBit(LCD_COM,(LCD_CS1+LCD_CS2));
	#else
		ClrBit(LCD_COM,(LCD_CS1+LCD_CS2));
	#endif	
	//SetBit(LCD_COM,LCD_E);
}

void WG_WriteData(unsigned char data,unsigned char CS)
{ 
	#ifdef WG12864B
		ClrBit(LCD_COM,CS);
	#else
		SetBit(LCD_COM,CS);
	#endif
	SetBit(LCD_COM,LCD_RS);
	ClrBit(LCD_COM,LCD_RW); 
	NOP(); 
	NOP();
	LCD_DPORT=data;
	SetBit(LCD_COM,LCD_E);
	NOP();
	NOP();  
	ClrBit(LCD_COM,LCD_E);
	delay_us(4);
	#ifdef WG12864B
		SetBit(LCD_COM,(LCD_CS1+LCD_CS2));
	#else
		ClrBit(LCD_COM,(LCD_CS1+LCD_CS2));
	#endif
	//SetBit(LCD_COM,LCD_E);
}

void WG_WriteXY(unsigned char x,unsigned char y,const unsigned char CS)
{ 
	WG_WriteCom(0xb8+y,CS);
	WG_WriteCom(0x40+x,CS);
}

void WG_init_lcd(void)
{ 
	LCD_CIO = (LCD_RST | LCD_E | LCD_RW | LCD_RS | LCD_CS2 | LCD_CS1);
	LCD_DIO=0xFF;
	SetBit(LCD_COM,LCD_RST);
	delay_us(5);  
	WG_WriteXY(0,0,(LCD_CS1+LCD_CS2));
	WG_WriteCom(0xc0,(LCD_CS1+LCD_CS2));
	WG_WriteCom(0x3f,(LCD_CS1+LCD_CS2));  
}

void WG_clear(void)
{
	unsigned char x,y;
	for(x=0;x<64;x++)
	{
		for(y=0;y<8;y++)
		{
			WG_WriteXY(x,y,(LCD_CS1+LCD_CS2));   
			WG_WriteData(0,(LCD_CS1+LCD_CS2));   
		} 
	}
}

unsigned char WG_gotoxy(unsigned char x, unsigned y)
{
	unsigned char CS, textCS;

	if(x < 10)
	{
		CS=LCD_CS1;
		textCS=0;
	}
	else
	{
		CS=LCD_CS2;
		textCS=64;
	}
	WG_WriteXY(x*6-textCS+4,y,CS);
 
	return CS;
}

void WG_SetTextXY(unsigned char x, unsigned y)
{
	textx = x;
	texty = y;
}

void WG_putc (unsigned char data, unsigned char inv)
{
	unsigned char textL, CS=WG_gotoxy(textx,texty);
	const char *progmem_s;
	uint8_t i;

	if(data < 0x90)
	{
		textL=0x20;
	}
	else
	{
		textL=0x60;
	}
 
	progmem_s = symbol+(data-textL);
	for (i=0;i<5;i++) { 
		WG_WriteData(pgm_read_byte(progmem_s++)^inv,CS);
	}

	WG_WriteData(0^inv,CS);
 
	if(textx < 19)
	{
		textx++;
	}
	else
	{
		textx=0;
		if(texty < 8) texty++;
	}
}



void WG_put_big_number (unsigned char n, unsigned char inv)
{
	unsigned CS=WG_gotoxy(textx,texty);
	const char *progmem_s;
	uint8_t i;


	if ((n > 47) & (n < 58)) {
		n = n - 48;
	}
	if (n == '.')
		n = 10;
	if (n == '-')
		n = 11;
	if (n == '+')
		n = 12;
	if (n == ' ')
		n = 13;


	progmem_s=big_number[n];
	
	WG_WriteData(0^inv,CS);
	for (i=0;i<10;i++) { 
		WG_WriteData(pgm_read_byte(progmem_s++)^inv,CS);
		if ((textx == 9) && (i==4)) { //      "",     CS
			CS=WG_gotoxy(textx+1,texty);
		}
	}
	WG_WriteData(0^inv,CS);
	
	CS=WG_gotoxy(textx,texty+1);

	WG_WriteData(0^inv,CS);
	for (i=0;i<10;i++) { 
		WG_WriteData(pgm_read_byte(progmem_s++)^inv,CS);
		if ((textx == 9) && (i==4)) {  //      "",     CS
			CS=WG_gotoxy(textx+1,texty+1);
		}
	}
	WG_WriteData(0^inv,CS);
 
	if(textx < 18)
	{
		textx+=2;
	}
	else
	{
		textx=0;
		if(texty < 7) texty+=2;
	}
}


void WG_puts (unsigned char x, unsigned char y, unsigned char str[],unsigned char n,unsigned char inv)
{
	textx = x;
	texty = y;
	unsigned char a;
	for(a=0;(a<n)&&(a<strlen(str));a++)
	{
		WG_putc(str[a],inv);
	}
}

//void WG_puts_big (unsigned char x, unsigned char y, unsigned char str[],unsigned char n,unsigned char inv)
void WG_puts_big (unsigned char x, unsigned char y, char str[],unsigned char n,unsigned char inv)
{
	textx = x;
	texty = y;
	unsigned char a;
	for(a=0;(a<n)&&(a<strlen(str));a++)
	{
		WG_put_big_number(str[a],inv);
	}
}

/*
unsigned char WG_ReadData(unsigned char CS)
{
	unsigned char data=0;
	LCD_DIO=0;
	SetBit(LCD_COM,CS); 
	SetBit(LCD_COM,LCD_RS);
	SetBit(LCD_COM,LCD_RW);  
	NOP(); 
	NOP();  
	SetBit(LCD_COM,LCD_E);
	NOP();
	data=LCD_DPIN;
	ClrBit(LCD_COM,LCD_E); 
	delay_us(4);
	ClrBit(LCD_COM,(LCD_CS1+LCD_CS2));
	SetBit(LCD_COM,LCD_E);
	LCD_DIO=0xff;
	return data;
}
*/


unsigned char WG_ReadData(unsigned char CS)
{
	unsigned char data=0;
	LCD_DIO=0x00;
	
	#ifdef WG12864B
		ClrBit(LCD_COM,CS);
	#else
		SetBit(LCD_COM,CS);
	#endif
	SetBit(LCD_COM,LCD_RS);
	SetBit(LCD_COM,LCD_RW);	
	SetBit(LCD_COM,LCD_E);
	//NOP();
	delay_us(1);
	ClrBit(LCD_COM,LCD_E);
	delay_us(4);
	//NOP();
	//NOP();
	//NOP();
	//NOP();
	SetBit(LCD_COM,LCD_E);
	//NOP();
	delay_us(2);
	data=LCD_DPIN;
	ClrBit(LCD_COM,LCD_E);
	//NOP();
	delay_us(1);
	#ifdef WG12864B
		SetBit(LCD_COM,(LCD_CS1+LCD_CS2));
	#else
		ClrBit(LCD_COM,(LCD_CS1+LCD_CS2));
	#endif
	SetBit(LCD_COM,LCD_E);
	LCD_DIO=0xff;
	return data;
}


void WG_getc (unsigned char data[],unsigned char readx,unsigned ready)
{
	unsigned char CS; 
	CS=WG_gotoxy(readx,ready); 
 
	WG_ReadData(CS);
	data[0]=WG_ReadData(CS);
	data[1]=WG_ReadData(CS);
	data[2]=WG_ReadData(CS);
	data[3]=WG_ReadData(CS);
	data[4]=WG_ReadData(CS);
	data[5]=WG_ReadData(CS);
}

void WG_DelCur(void)
{
	unsigned char CS=WG_gotoxy(curx,cury);
   
	WG_WriteData(ch[0],CS);
	WG_WriteData(ch[1],CS);
	WG_WriteData(ch[2],CS);
	WG_WriteData(ch[3],CS);
	WG_WriteData(ch[4],CS); 
}

void WG_SetCur(unsigned char x, unsigned char y)
{
	unsigned char CS;
  
	WG_DelCur();
	curx=x;
	cury=y;
  
	CS=WG_gotoxy(curx,cury);
 
	WG_getc(ch,x,y);
  
	WG_gotoxy(curx,cury);
 
	WG_WriteData(ch[0]|0x80,CS);
	WG_WriteData(ch[1]|0x80,CS);
	WG_WriteData(ch[2]|0x80,CS);
	WG_WriteData(ch[3]|0x80,CS);
	WG_WriteData(ch[4]|0x80,CS); 
}


void WG_show_img(const char* img, uint8_t sx, uint8_t sy,  uint8_t x, uint8_t y) {
	uint8_t ix,iy, addline=0;
	uint8_t dy, by;//, sx, sy;
	uint8_t gx;
	uint8_t byte, byte_prev;
	unsigned char CS;
	const char *progmem_s;

	dy = y/8;
	by = y-dy*8;

	if (by > 0) addline = 1;

	for (iy=0; iy<sy+addline; iy++) {
		// Move to first position in line
		if (x > 64) {
			CS = LCD_CS2;
			gx = x-64;			
		}
		else {
			CS = LCD_CS1;
			gx = x;
		}
		WG_WriteXY(gx,dy+iy,CS);
		//
		
		if (iy<sy) {
			progmem_s = img + (iy*sx); //img[iy];
		}
		else {
			progmem_s = img + ((iy-1)*sx); //img[iy-1]; // additional line
		}

		for (ix=0; ix<sx; ix++) {
			// Turn CS when x > 63
			if (gx == 64) {
				CS = LCD_CS2;
				gx = 0;
				WG_WriteXY(gx,dy+iy,CS);
			}
			//
			
			if (iy<sy) {
				if (iy > 0) { //    
			  		byte_prev = pgm_read_byte(progmem_s - sx) >> (8-by);
				}
				else {
					byte_prev = 0;
				}

				byte = (pgm_read_byte(progmem_s++) << by) | byte_prev;
			}
			else {
				byte = (pgm_read_byte(progmem_s++) >> (8-by));  // additional line
			}
			
			WG_WriteData(byte,CS);
			gx++;
		}
	}
}





void WG_put_pixel (unsigned char x, unsigned char y, const unsigned char color)
{
	unsigned char temp=0;
	unsigned char CS;
	uint8_t yy;

	if ( (x>128)||(y>64) ) return;

	if(x > 63)
	{
		x = x-64;
		CS=LCD_CS2;
	}
	else
	{
		CS=LCD_CS1;
	}

	yy = y/8;

	///////////////////////
	WG_WriteXY(x,yy,CS);
	temp = WG_ReadData(CS);
	///////////////////////

	if (color==1) temp |= (1<<(y-yy*8));	//Enable/Disable bit
	else temp &=~(1<<(y-yy*8));

	WG_WriteXY(x,yy,CS);
	WG_WriteData(temp, CS);
}

int sign (int x)
{
  if (x<0) return -1;
  if (x>0) return 1;
  return 0;
}


void WG_line (unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char color)
{ int dx,dy,i,sx,sy,check,e,x,y;

  dx=abs(x1-x2);
  dy=abs(y1-y2);
  sx=sign(x2-x1);
  sy=sign(y2-y1);
   x=x1;
   y=y1;
   check=0;
  if (dy>dx) {
              dx=dx+dy;
              dy=dx-dy;
              dx=dx-dy;
              check=1;
             }
  e=2*dy - dx;
   for (i=0;i<=dx;i++)
    {
     WG_put_pixel(x,y,color);
     if (e>=0) {
	             if (check==1) x=x+sx;
				          else y=y+sy;
                 e=e-2*dx;
               }
     if (check==1) y=y+sy; 
	          else x=x+sx;
     e=e+2*dy;
    } 
}


void WG_rect(unsigned char x1,unsigned char y1,unsigned char x2,unsigned char y2,unsigned char color)
{ int n;
  
  for (n=x1;n<x2;n++) {
    WG_put_pixel(n,y1,1);
	WG_put_pixel(n,y2,1);
  }
  for (n=y1;n<y2;n++) {
    WG_put_pixel(x1,n,1);
	WG_put_pixel(x2-1,n,1);
  }
}
